/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.graph;

import edu.colorado.phet.common.phetcommon.util.ConstantPowerOfTenNumberFormat;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class LinearYAxisNode
extends PComposite {
    private final PDimension _graphOutlineSize;
    private final int _numberOfTicks;
    private final double _topMargin;
    private int _exponent;
    private final double _mantissaSpacing;
    private final double _tickLength;
    private final Stroke _tickStroke;
    private final Color _tickColor;
    private final Font _labelFont;
    private final Color _labelColor;
    private final Stroke _gridlineStroke;
    private final Color _gridlineColor;
    private final PNode _partsNode;

    public LinearYAxisNode(PDimension pDimension, int n, double d, int n2, double d2, double d3, Stroke stroke, Color color, Font font, Color color2, Stroke stroke2, Color color3) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._graphOutlineSize = new PDimension(pDimension);
        this._numberOfTicks = n;
        this._topMargin = d;
        this._exponent = n2;
        this._mantissaSpacing = d2;
        this._tickLength = d3;
        this._tickStroke = stroke;
        this._tickColor = color;
        this._labelFont = font;
        this._labelColor = color2;
        this._gridlineStroke = stroke2;
        this._gridlineColor = color3;
        this._partsNode = new PComposite();
        this.addChild(this._partsNode);
        this.update();
    }

    public void setTicksExponent(int n) {
        if (n != this._exponent) {
            this._exponent = n;
            this.update();
        }
    }

    private void update() {
        this._partsNode.removeAllChildren();
        double d = this._graphOutlineSize.getHeight() - this._topMargin;
        double d2 = d / (double)(this._numberOfTicks - 1);
        ConstantPowerOfTenNumberFormat constantPowerOfTenNumberFormat = new ConstantPowerOfTenNumberFormat("0", this._exponent);
        double d3 = this._graphOutlineSize.getHeight();
        for (int i = 0; i < this._numberOfTicks; ++i) {
            PPath pPath;
            if (i % 2 == 0) {
                pPath = new PPath(new Line2D.Double(-(this._tickLength / 2.0), d3, this._tickLength / 2.0, d3));
                pPath.setStroke(this._tickStroke);
                pPath.setStrokePaint(this._tickColor);
                this._partsNode.addChild(pPath);
                String string = null;
                if (i == 0) {
                    string = "0";
                } else {
                    double d4 = (double)i * this._mantissaSpacing * Math.pow(10.0, this._exponent);
                    string = constantPowerOfTenNumberFormat.format(d4);
                }
                HTMLNode hTMLNode = new HTMLNode(string);
                hTMLNode.setFont(this._labelFont);
                hTMLNode.setHTMLColor(this._labelColor);
                double d5 = pPath.getFullBoundsReference().getMinX() - hTMLNode.getFullBoundsReference().getWidth() - 5.0;
                double d6 = pPath.getFullBoundsReference().getCenterY() - hTMLNode.getFullBoundsReference().getHeight() / 2.0;
                hTMLNode.setOffset(d5, d6);
                this._partsNode.addChild(hTMLNode);
            }
            pPath = new PPath(new Line2D.Double(this._tickLength / 2.0, d3, this._graphOutlineSize.getWidth() - this._tickLength / 2.0, d3));
            pPath.setStroke(this._gridlineStroke);
            pPath.setStrokePaint(this._gridlineColor);
            this._partsNode.addChild(pPath);
            d3 -= d2;
        }
    }
}

