/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.graph;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.TimesTenNumberFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.FormattedNumberNode;
import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.PHScaleStrings;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.view.graph.BarDragHandleNode;
import edu.colorado.phet.phscale.view.graph.BarNode;
import edu.colorado.phet.phscale.view.graph.LinearYAxisNode;
import edu.colorado.phet.phscale.view.graph.LogYAxisNode;
import edu.colorado.phet.phscale.view.graph.ZoomControlPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class GraphNode
extends PNode {
    private static final Stroke OUTLINE_STROKE = new BasicStroke(1.0f);
    private static final Color OUTLINE_STROKE_COLOR = Color.BLACK;
    private static final Color OUTLINE_FILL_COLOR = Color.WHITE;
    private static final Color H3O_BAR_COLOR = PHScaleConstants.H3O_COLOR;
    private static final Color OH_BAR_COLOR = PHScaleConstants.OH_COLOR;
    private static final Color H2O_BAR_COLOR = PHScaleConstants.H2O_COLOR;
    private static final Font VALUE_FONT = new PhetFont(1, 18);
    private static final Color VALUE_COLOR = Color.BLACK;
    private static final TimesTenNumberFormat H3O_FORMAT = new TimesTenNumberFormat("0.00");
    private static final TimesTenNumberFormat OH_FORMAT = new TimesTenNumberFormat("0.00");
    private static final DecimalFormat H2O_FORMAT = new DefaultDecimalFormat("#0");
    private static final Font AXIS_LABEL_FONT = new PhetFont(14);
    private static final Color AXIS_LABEL_COLOR = Color.BLACK;
    private static final String AXIS_LABEL_CONCENTRATION = PHScaleStrings.getConcentrationString();
    private static final String AXIS_LABEL_NUMBER_OF_MOLES = PHScaleStrings.getNumberOfMolesString();
    private static final Stroke TICK_STROKE = new BasicStroke(1.0f);
    private static final Color TICK_COLOR = Color.BLACK;
    private static final Font TICK_LABEL_FONT = new PhetFont(14);
    private static final Color TICK_LABEL_COLOR = Color.BLACK;
    private static final Stroke GRIDLINE_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private static final Color GRIDLINE_COLOR = new Color(192, 192, 192, 100);
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private final double _graphOutlineHeight;
    private final FormattedNumberNode _h3oNumberNode;
    private final FormattedNumberNode _ohNumberNode;
    private final FormattedNumberNode _h2oNumberNode;
    private final LogYAxisNode _logYAxisNode;
    private final LinearYAxisNode _linearYAxisNode;
    private final BarNode _h3oBarNode;
    private final BarNode _ohBarNode;
    private final BarNode _h2oBarNode;
    private final BarDragHandleNode _h3oDragHandleNode;
    private final BarDragHandleNode _ohDragHandleNode;
    private final ZoomControlPanel _zoomControlPanel;
    private final PSwing _zoomPanelWrapper;
    private final PText _yAxisLabel;
    private boolean _logScale;
    private boolean _concentrationUnits;
    private int _linearTicksExponent;

    public GraphNode(Liquid liquid, double d, double d2) {
        this._graphOutlineHeight = 18.0 * d2 + 10.0;
        this._logScale = true;
        this._concentrationUnits = true;
        this._linearTicksExponent = 1;
        this._liquid = liquid;
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                GraphNode.this.updateValues();
                GraphNode.this.updateBars();
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d, this._graphOutlineHeight);
        PPath pPath = new PPath(double_);
        pPath.setStroke(OUTLINE_STROKE);
        pPath.setStrokePaint(OUTLINE_STROKE_COLOR);
        pPath.setPaint(OUTLINE_FILL_COLOR);
        pPath.setPickable(false);
        pPath.setChildrenPickable(false);
        this.addChild(pPath);
        PDimension pDimension = new PDimension(d, this._graphOutlineHeight);
        this._logYAxisNode = new LogYAxisNode(pDimension, 19, 10.0, 2, 2, 6.0, TICK_STROKE, TICK_COLOR, TICK_LABEL_FONT, TICK_LABEL_COLOR, GRIDLINE_STROKE, GRIDLINE_COLOR);
        this.addChild(this._logYAxisNode);
        this._linearYAxisNode = new LinearYAxisNode(pDimension, 19, 10.0, 1, 0.5, 6.0, TICK_STROKE, TICK_COLOR, TICK_LABEL_FONT, TICK_LABEL_COLOR, GRIDLINE_STROKE, GRIDLINE_COLOR);
        this.addChild(this._linearYAxisNode);
        this._yAxisLabel = new PText();
        this._yAxisLabel.rotate(-1.5707963267948966);
        this._yAxisLabel.setFont(AXIS_LABEL_FONT);
        this._yAxisLabel.setTextPaint(AXIS_LABEL_COLOR);
        this._yAxisLabel.setPickable(false);
        this.addChild(this._yAxisLabel);
        this._h3oBarNode = new BarNode(50.0, H3O_BAR_COLOR, this._graphOutlineHeight);
        this.addChild(this._h3oBarNode);
        this._ohBarNode = new BarNode(50.0, OH_BAR_COLOR, this._graphOutlineHeight);
        this.addChild(this._ohBarNode);
        this._h2oBarNode = new BarNode(50.0, H2O_BAR_COLOR, this._graphOutlineHeight);
        this.addChild(this._h2oBarNode);
        PPath pPath2 = new PPath(new Line2D.Double(0.0, this._graphOutlineHeight, d, this._graphOutlineHeight));
        pPath2.setStroke(OUTLINE_STROKE);
        pPath2.setStrokePaint(OUTLINE_STROKE_COLOR);
        pPath2.setPickable(false);
        this.addChild(pPath2);
        this._h3oNumberNode = GraphNode.createNumberNode(H3O_FORMAT);
        this.addChild(this._h3oNumberNode);
        this._ohNumberNode = GraphNode.createNumberNode(OH_FORMAT);
        this.addChild(this._ohNumberNode);
        this._h2oNumberNode = GraphNode.createNumberNode(H2O_FORMAT);
        this.addChild(this._h2oNumberNode);
        this.updateValues();
        this._zoomControlPanel = new ZoomControlPanel();
        this._zoomControlPanel.addZoomControlPanelListener(new ZoomControlPanel.ZoomControlPanelListener(){

            public void zoomIn() {
                GraphNode.this.zoomInLinear();
            }

            public void zoomOut() {
                GraphNode.this.zoomOutLinear();
            }
        });
        this._zoomPanelWrapper = new PSwing(this._zoomControlPanel);
        this._zoomPanelWrapper.setVisible(!this._logScale);
        this.addChild(this._zoomPanelWrapper);
        this._h3oDragHandleNode = new BarDragHandleNode();
        this._h3oDragHandleNode.addInputEventListener(new H3OBarDragHandler());
        this.addChild(this._h3oDragHandleNode);
        this._ohDragHandleNode = new BarDragHandleNode();
        this._ohDragHandleNode.addInputEventListener(new OHBarDragHandler());
        this.addChild(this._ohDragHandleNode);
        pPath.setOffset(0.0, 0.0);
        PBounds pBounds = pPath.getFullBoundsReference();
        this._logYAxisNode.setOffset(pPath.getOffset());
        this._linearYAxisNode.setOffset(pPath.getOffset());
        double d3 = (pPath.getWidth() - 150.0) / 12.0;
        assert (d3 > 0.0);
        double d4 = 0.16666666666666666 * pBounds.getWidth() + d3;
        double d5 = 0.5 * pBounds.getWidth();
        double d6 = 0.8333333333333334 * pBounds.getWidth() - d3;
        this._h3oNumberNode.setOffset(d4 - this._h3oNumberNode.getFullBoundsReference().getWidth() / 2.0, pBounds.getMaxY() - this._h3oNumberNode.getFullBoundsReference().getHeight() - 10.0);
        this._ohNumberNode.setOffset(d5 - this._ohNumberNode.getFullBoundsReference().getWidth() / 2.0, pBounds.getMaxY() - this._ohNumberNode.getFullBoundsReference().getHeight() - 10.0);
        this._h2oNumberNode.setOffset(d6 - this._h2oNumberNode.getFullBoundsReference().getWidth() / 2.0, pBounds.getMaxY() - this._h2oNumberNode.getFullBoundsReference().getHeight() - 10.0);
        this._h3oBarNode.setOffset(d4, pDimension.getHeight());
        this._ohBarNode.setOffset(d5, pDimension.getHeight());
        this._h2oBarNode.setOffset(d6, pDimension.getHeight());
        this._zoomPanelWrapper.setOffset(pBounds.getCenterX() - this._zoomPanelWrapper.getFullBoundsReference().getWidth() / 2.0, 60.0);
        this._h3oDragHandleNode.setOffset(d4 - 25.0 + 10.0, pDimension.getHeight() - this._h3oDragHandleNode.getFullBoundsReference().getHeight() / 2.0);
        this._ohDragHandleNode.setOffset(d5 - 25.0 + 10.0, pDimension.getHeight() - this._ohDragHandleNode.getFullBoundsReference().getHeight() / 2.0);
        this.updateYAxis();
        this.updateBars();
        this.updateZoomControls();
    }

    private static FormattedNumberNode createNumberNode(NumberFormat numberFormat) {
        FormattedNumberNode formattedNumberNode = new FormattedNumberNode(numberFormat, 0.0, VALUE_FONT, VALUE_COLOR);
        formattedNumberNode.rotate(-1.5707963267948966);
        formattedNumberNode.setPickable(false);
        formattedNumberNode.setChildrenPickable(false);
        return formattedNumberNode;
    }

    public void setLogScale(boolean bl) {
        if (bl != this._logScale) {
            this._logScale = bl;
            if (!this._logScale) {
                this._linearTicksExponent = 1;
            }
            this.updateYAxis();
            this.updateBars();
            this.updateZoomControls();
        }
    }

    public void setConcentrationUnits(boolean bl) {
        if (bl != this._concentrationUnits) {
            this._concentrationUnits = bl;
            this.updateValues();
            this.updateYAxis();
            this.updateBars();
        }
    }

    public Point2D getTickAlignmentGlobalOffset() {
        return this.localToGlobal(new Point2D.Double(0.0, this._logYAxisNode.getYOffset() + 10.0 + this._logYAxisNode.getTickSpacing()));
    }

    private void zoomInLinear() {
        --this._linearTicksExponent;
        this.updateYAxis();
        this.updateBars();
        this.updateZoomControls();
    }

    private void zoomOutLinear() {
        ++this._linearTicksExponent;
        this.updateYAxis();
        this.updateBars();
        this.updateZoomControls();
    }

    private void updateValues() {
        if (this._concentrationUnits) {
            this._h3oNumberNode.setValue(this._liquid.getConcentrationH3O());
            this._ohNumberNode.setValue(this._liquid.getConcentrationOH());
            this._h2oNumberNode.setValue(this._liquid.getConcentrationH2O());
        } else {
            this._h3oNumberNode.setValue(this._liquid.getMolesH3O());
            this._ohNumberNode.setValue(this._liquid.getMolesOH());
            this._h2oNumberNode.setValue(this._liquid.getMolesH2O());
        }
    }

    private void updateYAxis() {
        if (!this._logScale) {
            this._linearYAxisNode.setTicksExponent(this._linearTicksExponent);
        }
        this._logYAxisNode.setVisible(this._logScale);
        this._linearYAxisNode.setVisible(!this._logScale);
        this._yAxisLabel.setText(this._concentrationUnits ? AXIS_LABEL_CONCENTRATION : AXIS_LABEL_NUMBER_OF_MOLES);
        if (this._logScale) {
            double d = this._logYAxisNode.getFullBoundsReference().getX() - this._yAxisLabel.getFullBoundsReference().getWidth() - 4.0;
            double d2 = this._logYAxisNode.getFullBoundsReference().getCenterY() + this._yAxisLabel.getFullBoundsReference().getHeight() / 2.0;
            this._yAxisLabel.setOffset(d, d2);
        } else {
            double d = this._linearYAxisNode.getFullBoundsReference().getX() - this._yAxisLabel.getFullBoundsReference().getWidth() - 4.0;
            double d3 = this._linearYAxisNode.getFullBoundsReference().getCenterY() + this._yAxisLabel.getFullBoundsReference().getHeight() / 2.0;
            this._yAxisLabel.setOffset(d, d3);
        }
    }

    private void updateBars() {
        double d = this.getH3OBarHeight();
        double d2 = this.getOHBarHeight();
        double d3 = this.getH2OHeight();
        this._h3oBarNode.setBarHeight(d);
        this._ohBarNode.setBarHeight(d2);
        this._h2oBarNode.setBarHeight(d3);
        GraphNode.updateDragHandle(this._h3oDragHandleNode, d, this._graphOutlineHeight);
        GraphNode.updateDragHandle(this._ohDragHandleNode, d2, this._graphOutlineHeight);
    }

    private double getH3OBarHeight() {
        double d = 0.0;
        d = this._concentrationUnits ? this._liquid.getConcentrationH3O() : this._liquid.getMolesH3O();
        return this.calculateBarHeight(d);
    }

    private double getOHBarHeight() {
        double d = 0.0;
        d = this._concentrationUnits ? this._liquid.getConcentrationOH() : this._liquid.getMolesOH();
        return this.calculateBarHeight(d);
    }

    private double getH2OHeight() {
        double d = 0.0;
        d = this._concentrationUnits ? this._liquid.getConcentrationH2O() : this._liquid.getMolesH2O();
        return this.calculateBarHeight(d);
    }

    private double calculateBarHeight(double d) {
        double d2 = 0.0;
        double d3 = this._graphOutlineHeight - 10.0;
        if (this._logScale) {
            double d4 = MathUtil.log10(d);
            d2 = d3 * (d4 - -16.0) / 18.0;
        } else {
            double d5 = 9.0 * Math.pow(10.0, this._linearTicksExponent);
            d2 = d3 * d / d5;
        }
        return d2;
    }

    private static void updateDragHandle(PNode pNode, double d, double d2) {
        pNode.setVisible(d > 0.0 && d <= d2);
        if (pNode.getVisible()) {
            pNode.setOffset(pNode.getXOffset(), d2 - d);
        }
    }

    private void updateZoomControls() {
        this._zoomPanelWrapper.setVisible(!this._logScale);
        this._zoomControlPanel.setZoomInEnabled(this._linearTicksExponent != -15);
        this._zoomControlPanel.setZoomOutEnabled(this._linearTicksExponent != 1);
    }

    private abstract class BarDragHandler
    extends PDragEventHandler {
        private double _globalClickYOffset;

        private BarDragHandler() {
        }

        protected void startDrag(PInputEvent pInputEvent) {
            super.startDrag(pInputEvent);
            Point2D point2D = pInputEvent.getPositionRelativeTo(GraphNode.this);
            Point2D point2D2 = GraphNode.this.localToGlobal(point2D);
            Point2D point2D3 = GraphNode.this.localToGlobal(pInputEvent.getPickedNode().getOffset());
            this._globalClickYOffset = point2D2.getY() - point2D3.getY();
        }

        protected void drag(PInputEvent pInputEvent) {
            Point2D point2D = pInputEvent.getPositionRelativeTo(GraphNode.this);
            Point2D point2D2 = GraphNode.this.localToGlobal(point2D);
            Point2D.Double double_ = new Point2D.Double(point2D2.getX(), point2D2.getY() - this._globalClickYOffset);
            Point2D point2D3 = GraphNode.this.globalToLocal(double_);
            double d = GraphNode.this._graphOutlineHeight - point2D3.getY();
            if (d < 0.0) {
                d = 0.0;
            } else if (d > GraphNode.this._graphOutlineHeight) {
                d = GraphNode.this._graphOutlineHeight;
            }
            double d2 = 0.0;
            double d3 = GraphNode.this._graphOutlineHeight - 10.0;
            if (GraphNode.this._logScale) {
                double d4 = -16.0 + 18.0 * (d / d3);
                d2 = Math.pow(10.0, d4);
            } else {
                double d5 = 9.0 * Math.pow(10.0, GraphNode.this._linearTicksExponent);
                d2 = d5 * d / d3;
            }
            if (GraphNode.this._concentrationUnits) {
                this.setConcentration(d2);
            } else {
                this.setMoles(d2);
            }
        }

        protected abstract void setConcentration(double var1);

        protected abstract void setMoles(double var1);
    }

    private class H3OBarDragHandler
    extends BarDragHandler {
        private H3OBarDragHandler() {
        }

        protected void setConcentration(double d) {
            GraphNode.this._liquid.setConcentrationH3O(d);
        }

        protected void setMoles(double d) {
            GraphNode.this._liquid.setMolesH3O(d);
        }
    }

    private class OHBarDragHandler
    extends BarDragHandler {
        private OHBarDragHandler() {
        }

        protected void setConcentration(double d) {
            GraphNode.this._liquid.setConcentrationOH(d);
        }

        protected void setMoles(double d) {
            GraphNode.this._liquid.setMolesOH(d);
        }
    }
}

