/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.graph;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.phscale.PHScaleStrings;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.view.graph.GraphNode;
import edu.colorado.phet.phscale.view.graph.LegendNode;
import edu.colorado.phet.phscale.view.graph.ScaleControlPanel;
import edu.colorado.phet.phscale.view.graph.UnitsControlPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Font;
import java.awt.geom.Point2D;

public class GraphControlNode
extends PNode {
    private static final Font TITLE_FONT = new PhetFont(1, 20);
    private final GraphNode _graphNode;
    private final UnitsControlPanel _unitsControlPanel;
    private final ScaleControlPanel _scaleControlPanel;

    public GraphControlNode(Liquid liquid, double d) {
        PText pText = new PText(PHScaleStrings.TITLE_WATER_COMPONENTS);
        pText.setFont(TITLE_FONT);
        this.addChild(pText);
        this._unitsControlPanel = new UnitsControlPanel();
        this._unitsControlPanel.addUnitsControlPanelListener(new UnitsControlPanel.UnitsControlPanelListener(){

            public void selectionChanged() {
                GraphControlNode.this._graphNode.setConcentrationUnits(GraphControlNode.this._unitsControlPanel.isConcentrationSelected());
            }
        });
        PSwing pSwing = new PSwing(this._unitsControlPanel);
        this.addChild(pSwing);
        this._graphNode = new GraphNode(liquid, 225.0, d);
        this.addChild(this._graphNode);
        LegendNode legendNode = new LegendNode();
        this.addChild(legendNode);
        this._scaleControlPanel = new ScaleControlPanel();
        this._scaleControlPanel.addScaleControlPanelListener(new ScaleControlPanel.ScaleControlPanelListener(){

            public void selectionChanged() {
                GraphControlNode.this._graphNode.setLogScale(GraphControlNode.this._scaleControlPanel.isLogSelected());
            }
        });
        PSwing pSwing2 = new PSwing(this._scaleControlPanel);
        this.addChild(pSwing2);
        pText.setOffset(0.0, 0.0);
        PBounds pBounds = pText.getFullBoundsReference();
        pSwing.setOffset(pBounds.getX(), pBounds.getMaxY() + 10.0);
        PBounds pBounds2 = pSwing.getFullBoundsReference();
        this._graphNode.setOffset(pBounds2.getX(), pBounds2.getMaxY() + 10.0);
        PBounds pBounds3 = this._graphNode.getFullBoundsReference();
        PBounds pBounds4 = legendNode.getFullBoundsReference();
        legendNode.setOffset((225.0 - pBounds4.getWidth()) / 2.0, pBounds3.getMaxY() + 2.0);
        pBounds4 = legendNode.getFullBoundsReference();
        pSwing2.setOffset(pSwing.getX(), pBounds4.getMaxY() + 10.0);
    }

    public void setConcentrationSelected(boolean bl) {
        this._unitsControlPanel.setConcentrationSelected(bl);
    }

    public void setLogSelected(boolean bl) {
        this._scaleControlPanel.setLogSelected(bl);
    }

    public Point2D getTickAlignmentGlobalOffset() {
        return this._graphNode.getTickAlignmentGlobalOffset();
    }
}

