/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.graph;

import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;

public class BarNode
extends PPath {
    private static final Stroke STROKE = null;
    private static final Color STROKE_COLOR = Color.BLACK;
    private final double _barWidth;
    private final double _graphHeight;
    private final double _arrowHeadWidth;
    private final GeneralPath _barShape;

    public BarNode(double d, Color color, double d2) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._barWidth = d;
        this._graphHeight = d2;
        this._arrowHeadWidth = d + 15.0;
        this._barShape = new GeneralPath();
        this.setPaint(color);
        this.setStroke(STROKE);
        this.setStrokePaint(STROKE_COLOR);
        this.setBarHeight(1.0);
    }

    public void setBarHeight(double d) {
        this._barShape.reset();
        if (d > this._graphHeight) {
            double d2 = this._graphHeight - 51.0;
            this._barShape.moveTo((float)(-(this._barWidth / 2.0)), 0.0f);
            this._barShape.lineTo((float)(this._barWidth / 2.0), 0.0f);
            this._barShape.lineTo((float)(this._barWidth / 2.0), (float)(-d2));
            this._barShape.lineTo((float)(this._arrowHeadWidth / 2.0), (float)(-d2));
            this._barShape.lineTo(0.0f, (float)(-(d2 + 60.0)));
            this._barShape.lineTo((float)(-(this._arrowHeadWidth / 2.0)), (float)(-d2));
            this._barShape.lineTo((float)(-(this._barWidth / 2.0)), (float)(-d2));
            this._barShape.closePath();
        } else if (d > 0.0) {
            this._barShape.moveTo((float)(-(this._barWidth / 2.0)), 0.0f);
            this._barShape.lineTo((float)(this._barWidth / 2.0), 0.0f);
            this._barShape.lineTo((float)(this._barWidth / 2.0), (float)(-d));
            this._barShape.lineTo((float)(-(this._barWidth / 2.0)), (float)(-d));
            this._barShape.closePath();
        }
        this.setPathTo(this._barShape);
    }
}

