/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.graph;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class BarDragHandleNode
extends PPath {
    private static final Color DEFAULT_NORMAL_COLOR = new Color(255, 255, 255, 200);
    private static final Color DEFAULT_HILITE_COLOR = Color.YELLOW;
    private static final Color DEFAULT_STROKE_COLOR = Color.BLACK;
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private Color _normalColor = DEFAULT_NORMAL_COLOR;
    private Color _hiliteColor = DEFAULT_HILITE_COLOR;

    public BarDragHandleNode() {
        Shape shape = BarDragHandleNode.createArrowShape(24.0f);
        this.setPathTo(shape);
        this.setPaint(DEFAULT_NORMAL_COLOR);
        this.setStroke(DEFAULT_STROKE);
        this.setStrokePaint(DEFAULT_STROKE_COLOR);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new HighlightHandler.PaintHighlightHandler(this, this._normalColor, this._hiliteColor));
    }

    private static Shape createArrowShape(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(0.25f * f, 0.33f * f);
        generalPath.lineTo(0.08f * f, 0.33f * f);
        generalPath.lineTo(0.08f * f, 0.67f * f);
        generalPath.lineTo(0.25f * f, 0.67f * f);
        generalPath.lineTo(0.0f * f, 1.0f * f);
        generalPath.lineTo(-0.25f * f, 0.67f * f);
        generalPath.lineTo(-0.08f * f, 0.67f * f);
        generalPath.lineTo(-0.08f * f, 0.33f * f);
        generalPath.lineTo(-0.25f * f, 0.33f * f);
        generalPath.closePath();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(0.0, -f / 2.0f);
        Shape shape = affineTransform.createTransformedShape(generalPath);
        return shape;
    }
}

