/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.model.LiquidDescriptor;
import edu.colorado.phet.phscale.view.beaker.FaucetControlNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class WaterControlNode
extends PNode {
    private static final PDimension LIQUID_COLUMN_SIZE = PHScaleConstants.LIQUID_COLUMN_SIZE;
    public static final Font FONT = PHScaleConstants.CONTROL_FONT;
    private static final LiquidDescriptor WATER = LiquidDescriptor.getWater();
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private final Rectangle2D _waterColumnShape;
    private final PPath _waterColumnNode;
    private final FaucetControlNode _faucetControlNode;
    private boolean _notifyEnabled = true;

    public WaterControlNode(Liquid liquid, double d) {
        this._liquid = liquid;
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                WaterControlNode.this.update();
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        WATER.addLiquidDescriptorListener(new LiquidDescriptor.LiquidDescriptorAdapter(){

            public void colorChanged(Color color) {
                WaterControlNode.this._waterColumnNode.setPaint(WATER.getColor());
            }
        });
        JLabel jLabel = new JLabel(WATER.toString());
        jLabel.setFont(FONT);
        PSwing pSwing = new PSwing(jLabel);
        this._faucetControlNode = new FaucetControlNode(2, d);
        this._faucetControlNode.addFaucetControlListener(new FaucetControlNode.FaucetControlListener(){

            public void valueChanged() {
                if (WaterControlNode.this._notifyEnabled) {
                    WaterControlNode.this._liquid.setWaterFillRate(WaterControlNode.this._faucetControlNode.getRate());
                }
            }
        });
        this._waterColumnShape = new Rectangle2D.Double();
        this._waterColumnNode = new PPath(this._waterColumnShape);
        this._waterColumnNode.setPaint(LiquidDescriptor.getWater().getColor());
        this._waterColumnNode.setStroke(null);
        this._waterColumnNode.setVisible(this._faucetControlNode.isOn());
        this._waterColumnNode.setPickable(false);
        this._waterColumnNode.setChildrenPickable(false);
        this.addChild(pSwing);
        this.addChild(this._waterColumnNode);
        this.addChild(this._faucetControlNode);
        pSwing.setOffset(0.0, 0.0);
        PBounds pBounds = pSwing.getFullBoundsReference();
        PBounds pBounds2 = this._faucetControlNode.getFullBoundsReference();
        this._faucetControlNode.setOffset(pBounds.getMaxX() - pBounds2.getWidth(), pBounds.getMaxY() + 5.0);
        this._waterColumnNode.setOffset(this._faucetControlNode.getFullBoundsReference().getMinX() + 18.0, this._faucetControlNode.getFullBoundsReference().getMaxY());
        this.update();
    }

    private void update() {
        this._notifyEnabled = false;
        this._faucetControlNode.setRate(this._liquid.getWaterFillRate());
        this._faucetControlNode.setEnabled(!this._liquid.isFull());
        this._notifyEnabled = true;
        this._waterColumnNode.setVisible(this._liquid.isFillingWater());
        double d = this._faucetControlNode.getPercentOn();
        double d2 = 2.0 + d * (LIQUID_COLUMN_SIZE.getWidth() - 2.0);
        this._waterColumnShape.setRect(-d2 / 2.0, 0.0, d2, LIQUID_COLUMN_SIZE.getHeight());
        this._waterColumnNode.setPathTo(this._waterColumnShape);
    }
}

