/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.phscale.PHScaleStrings;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.GeneralPath;
import java.text.DecimalFormat;

public class VolumeValueNode
extends PComposite {
    private static final DecimalFormat TEXT_FORMAT = new DefaultDecimalFormat("0.00");
    private static final Font TEXT_FONT = new PhetFont(1, 18);
    private static final Color TEXT_COLOR = Color.BLACK;
    private static final PDimension ARROW_SIZE = new PDimension(10.0, 15.0);
    private static final Color ARROW_COLOR = Color.BLACK;
    private final PText _textNode;

    public VolumeValueNode() {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._textNode = new PText("?");
        this._textNode.setFont(TEXT_FONT);
        this._textNode.setTextPaint(TEXT_COLOR);
        float f = (float)ARROW_SIZE.getWidth();
        float f2 = (float)ARROW_SIZE.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(f, -f2 / 2.0f);
        generalPath.lineTo(f, f2 / 2.0f);
        generalPath.closePath();
        PPath pPath = new PPath(generalPath);
        pPath.setPaint(ARROW_COLOR);
        this.addChild(pPath);
        this.addChild(this._textNode);
        pPath.setOffset(0.0, 0.0);
        this._textNode.setOffset(pPath.getFullBoundsReference().getMaxX() + 3.0, -this._textNode.getFullBoundsReference().getHeight() / 2.0);
    }

    public void setValue(double d) {
        String string = TEXT_FORMAT.format(d) + PHScaleStrings.UNITS_LITERS;
        this._textNode.setText(string);
    }
}

