/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.PHScaleStrings;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewControlPanel
extends JPanel {
    private static final Font CONTROL_FONT = PHScaleConstants.CONTROL_FONT;
    private final ArrayList _listeners;
    private final JCheckBox _countCheckBox;
    private final JCheckBox _ratioCheckBox;

    public ViewControlPanel() {
        this.setOpaque(false);
        this._listeners = new ArrayList();
        this._countCheckBox = new JCheckBox(PHScaleStrings.CHECK_BOX_MOLECULE_COUNT);
        this._countCheckBox.setOpaque(false);
        this._countCheckBox.setFont(CONTROL_FONT);
        this._countCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ViewControlPanel.this.notifyCountChanged();
            }
        });
        this._ratioCheckBox = new JCheckBox(PHScaleStrings.getBeakerViewRatioString());
        this._ratioCheckBox.setOpaque(false);
        this._ratioCheckBox.setFont(CONTROL_FONT);
        this._ratioCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ViewControlPanel.this.notifyRatioChanged();
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._countCheckBox, n++, n2);
        easyGridBagLayout.addComponent(this._ratioCheckBox, n++, n2);
    }

    public boolean isCountSelected() {
        return this._countCheckBox.isSelected();
    }

    public void setCountSelected(boolean bl) {
        if (bl != this.isCountSelected()) {
            this._countCheckBox.setSelected(bl);
            this.notifyCountChanged();
        }
    }

    public boolean isRatioSelected() {
        return this._ratioCheckBox.isSelected();
    }

    public void setRatioSelected(boolean bl) {
        if (bl != this.isRatioSelected()) {
            this._ratioCheckBox.setSelected(bl);
            this.notifyRatioChanged();
        }
    }

    public void addViewControlPanelListener(ViewControlPanelListener viewControlPanelListener) {
        this._listeners.add(viewControlPanelListener);
    }

    private void notifyCountChanged() {
        boolean bl = this._countCheckBox.isSelected();
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ViewControlPanelListener)iterator.next()).countChanged(bl);
        }
    }

    private void notifyRatioChanged() {
        boolean bl = this._ratioCheckBox.isSelected();
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((ViewControlPanelListener)iterator.next()).ratioChanged(bl);
        }
    }

    public static interface ViewControlPanelListener {
        public void countChanged(boolean var1);

        public void ratioChanged(boolean var1);
    }
}

