/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.phscale.PHScaleStrings;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.model.PHValue;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;

public class ProbeNode
extends PComposite {
    private static final Color SHAFT_COLOR = Color.DARK_GRAY;
    private static final Color TIP_COLOR = Color.BLACK;
    private static final Color DISPLAY_BORDER_COLOR = SHAFT_COLOR;
    private static final Font DISPLAY_FONT = new PhetFont(1, 18);
    private static final DecimalFormat DISPLAY_FORMAT = new DecimalFormat("#0.00");
    private static final Color DISPLAY_BACKGROUND = Color.LIGHT_GRAY;
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private final DisplayNode _displayNode;

    public ProbeNode(double d, Liquid liquid) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._liquid = liquid;
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                ProbeNode.this.update();
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        this._displayNode = new DisplayNode();
        TipNode tipNode = new TipNode();
        tipNode.scale(25.0);
        double d2 = d - this._displayNode.getFullBoundsReference().getHeight() - tipNode.getFullBoundsReference().getHeight();
        ShaftNode shaftNode = new ShaftNode(10.0, d2);
        this.addChild(shaftNode);
        this.addChild(tipNode);
        this.addChild(this._displayNode);
        PBounds pBounds = this._displayNode.getFullBoundsReference();
        PBounds pBounds2 = shaftNode.getFullBoundsReference();
        this._displayNode.setOffset(0.0, 0.0);
        shaftNode.setOffset(0.85 * (pBounds.getWidth() - pBounds2.getWidth()), pBounds.getHeight() - 1.5);
        pBounds2 = shaftNode.getFullBoundsReference();
        PBounds pBounds3 = tipNode.getFullBoundsReference();
        tipNode.setOffset(pBounds2.getX() + (pBounds2.getWidth() - pBounds3.getWidth()) / 2.0, pBounds2.getY() + pBounds2.getHeight());
        this.update();
    }

    private void update() {
        this._displayNode.setValue(this._liquid.getPH());
    }

    private static class DisplayNode
    extends PComposite {
        private PText _valueNode;

        public DisplayNode() {
            PText pText = new PText(PHScaleStrings.LABEL_PH);
            pText.setFont(DISPLAY_FONT);
            this._valueNode = new PText("XXX.XX");
            this._valueNode.setFont(DISPLAY_FONT);
            PComposite pComposite = new PComposite();
            pComposite.addChild(pText);
            pComposite.addChild(this._valueNode);
            pText.setOffset(0.0, 0.0);
            this._valueNode.setOffset(pText.getFullBoundsReference().getWidth() + 8.0, 0.0);
            PBounds pBounds = pComposite.getFullBoundsReference();
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, pBounds.getWidth() + 16.0, pBounds.getHeight() + 16.0, 10.0, 10.0);
            PPath pPath = new PPath(double_);
            this.addChild(pPath);
            pPath.setPaint(DISPLAY_BACKGROUND);
            pPath.setStroke(new BasicStroke(3.0f));
            pPath.setStrokePaint(DISPLAY_BORDER_COLOR);
            pPath.addChild(pComposite);
            pComposite.setOffset(8.0, 8.0);
        }

        public void setValue(PHValue pHValue) {
            if (pHValue != null) {
                double d = pHValue.getValue();
                String string = DISPLAY_FORMAT.format(d);
                this._valueNode.setText(string);
            } else {
                this._valueNode.setText("");
            }
        }
    }

    private static class ShaftNode
    extends PPath {
        public ShaftNode(double d, double d2) {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, d2));
            this.setPaint(SHAFT_COLOR);
            this.setStroke(null);
        }
    }

    private static class TipNode
    extends PPath {
        public TipNode() {
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(0.0f, 0.0f, 1.0f, 1.5f, 0.4f, 0.4f);
            Rectangle2D.Float float_2 = new Rectangle2D.Float(0.0f, 0.5f, 1.0f, 1.0f);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 1.5f);
            generalPath.lineTo(0.5f, 2.5f);
            generalPath.lineTo(1.0f, 1.5f);
            generalPath.closePath();
            Area area = new Area(float_);
            area.add(new Area(float_2));
            area.add(new Area(generalPath));
            this.setPathTo(area);
            this.setPaint(TIP_COLOR);
            this.setStroke(null);
        }
    }
}

