/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.phscale.PHScaleApplication;
import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.PHScaleStrings;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.model.PHValue;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Random;

public class ParticlesNode
extends PComposite {
    private static final Color DEFAULT_H3O_COLOR = PHScaleConstants.H3O_PARTICLES_COLOR;
    private static final Color DEFAULT_OH_COLOR = PHScaleConstants.OH_PARTICLES_COLOR;
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private final PBounds _containerBounds;
    private final PNode _particlesParent;
    private final Random _randomCoordinate;
    private HTMLNode _numbersNode;
    private PHValue _pH;
    private int _numberOfParticlesAtPH7;
    private int _numberOfParticlesAtPH15;
    private int _minMinorityParticles;
    private double _diameter;
    private int _majorityTransparency;
    private int _minorityTransparency;
    private Color _h3oColor;
    private Color _ohColor;
    private int _numberOfH3O;
    private int _numberOfOH;

    public ParticlesNode(Liquid liquid, PBounds pBounds) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._liquid = liquid;
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                ParticlesNode.this.update();
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        this._containerBounds = new PBounds(pBounds);
        this._randomCoordinate = new Random();
        this._pH = this._liquid.getPH();
        this._particlesParent = new PNode();
        this.addChild(this._particlesParent);
        if (PHScaleApplication.getInstance().isDeveloperControlsEnabled()) {
            this._numbersNode = new HTMLNode("?");
            this._numbersNode.setFont(new PhetFont());
            this.addChild(this._numbersNode);
            this._numbersNode.setOffset(pBounds.getX() + 5.0, pBounds.getMaxY() - this._numbersNode.getFullBoundsReference().getHeight() - 15.0);
        }
        this._numberOfParticlesAtPH15 = 3000;
        this._numberOfParticlesAtPH7 = 100;
        this._minMinorityParticles = 5;
        this._diameter = 6.0;
        this._majorityTransparency = 140;
        this._minorityTransparency = 255;
        this._h3oColor = DEFAULT_H3O_COLOR;
        this._ohColor = DEFAULT_OH_COLOR;
        this._numberOfH3O = 0;
        this._numberOfOH = 0;
        this.update();
    }

    public void setNumberOfParticlesAtPH15(int n) {
        if (n != this._numberOfParticlesAtPH15) {
            this._numberOfParticlesAtPH15 = n;
            this.createParticles();
        }
    }

    public int getNumberOfParticlesAtPH15() {
        return this._numberOfParticlesAtPH15;
    }

    public int getNumberOfParticlesAtPH7() {
        return this._numberOfParticlesAtPH7;
    }

    public void setNumberOfParticlesAtPH7(int n) {
        if (n != this._numberOfParticlesAtPH7) {
            this._numberOfParticlesAtPH7 = n;
            this.createParticles();
        }
    }

    public void setMinMinorityParticles(int n) {
        if (n != this._minMinorityParticles) {
            this._minMinorityParticles = n;
            this.createParticles();
        }
    }

    public int getMinMinorityParticles() {
        return this._minMinorityParticles;
    }

    public void setParticleDiameter(double d) {
        if (d != this._diameter) {
            this._diameter = d;
            int n = this._particlesParent.getChildrenCount();
            for (int i = 0; i < n; ++i) {
                ((ParticleNode)this._particlesParent.getChild(i)).setDiameter(d);
            }
        }
    }

    public double getParticleDiameter() {
        return this._diameter;
    }

    public void setMajorityTransparency(int n) {
        if (n != this._majorityTransparency) {
            this._majorityTransparency = n;
            this.setH3OColor(this._h3oColor);
            this.setOHColor(this._ohColor);
        }
    }

    public int getMajorityTransparency() {
        return this._majorityTransparency;
    }

    public void setMinorityTransparency(int n) {
        if (n != this._minorityTransparency) {
            this._minorityTransparency = n;
            this.setH3OColor(this._h3oColor);
            this.setOHColor(this._ohColor);
        }
    }

    public int getMinorityTransparency() {
        return this._minorityTransparency;
    }

    public void setH3OColor(Color color) {
        this._h3oColor = color;
        int n = this._numberOfH3O >= this._numberOfOH ? this._majorityTransparency : this._minorityTransparency;
        Color color2 = ColorUtils.createColor(this._h3oColor, n);
        int n2 = this._particlesParent.getChildrenCount();
        for (int i = 0; i < n2; ++i) {
            PNode pNode = this._particlesParent.getChild(i);
            if (!(pNode instanceof H3ONode)) continue;
            pNode.setPaint(color2);
        }
    }

    public Color getH3OColor() {
        return this._h3oColor;
    }

    public void setOHColor(Color color) {
        this._ohColor = color;
        int n = this._numberOfOH >= this._numberOfH3O ? this._majorityTransparency : this._minorityTransparency;
        Color color2 = ColorUtils.createColor(this._ohColor, n);
        int n2 = this._particlesParent.getChildrenCount();
        for (int i = 0; i < n2; ++i) {
            PNode pNode = this._particlesParent.getChild(i);
            if (!(pNode instanceof OHNode)) continue;
            pNode.setPaint(color2);
        }
    }

    public Color getOHColor() {
        return this._ohColor;
    }

    public void setVisible(boolean bl) {
        if (bl != this.getVisible()) {
            super.setVisible(bl);
            if (bl) {
                this.update();
            } else {
                this._pH = null;
                this._particlesParent.removeAllChildren();
            }
        }
    }

    private void update() {
        if (this.getVisible()) {
            PHValue pHValue = this._pH;
            this._pH = this._liquid.getPH();
            if (this._pH == null) {
                this.deleteAllParticles();
            } else if (!this._pH.equals(pHValue)) {
                this.createParticles();
            }
        }
    }

    private void updateNumbersNode(int n, int n2) {
        if (this._numbersNode != null) {
            this._numbersNode.setHTML("<html>" + PHScaleStrings.LABEL_H3O + "/" + PHScaleStrings.LABEL_OH + "= " + n + "/" + n2 + "<html>");
        }
    }

    private void deleteAllParticles() {
        this._particlesParent.removeAllChildren();
    }

    private void createParticles() {
        assert (this._pH != null);
        this.deleteAllParticles();
        double d = this._pH.getValue();
        if (d >= 6.0 && d <= 8.0) {
            this._numberOfH3O = Math.max(this._minMinorityParticles, this.getNumberOfH3OParticles(d));
            this._numberOfOH = Math.max(this._minMinorityParticles, this.getNumberOfOHParticles(d));
        } else {
            double d2 = (double)(this._numberOfParticlesAtPH15 - this.getNumberOfOHParticles(8.0)) / 7.0;
            if (d > 8.0) {
                double d3 = d - 8.0;
                this._numberOfH3O = (int)Math.max((double)this._minMinorityParticles, (double)this.getNumberOfH3OParticles(8.0) - d3);
                this._numberOfOH = (int)((double)this.getNumberOfOHParticles(8.0) + d3 * d2);
            } else {
                double d4 = 6.0 - d;
                this._numberOfH3O = (int)((double)this.getNumberOfH3OParticles(6.0) + d4 * d2);
                this._numberOfOH = (int)Math.max((double)this._minMinorityParticles, (double)this.getNumberOfOHParticles(6.0) - d4);
            }
        }
        this.updateNumbersNode(this._numberOfH3O, this._numberOfOH);
        if (this._numberOfH3O > this._numberOfOH) {
            this.createH3ONodes(this._numberOfH3O, this._majorityTransparency);
            this.createOHNodes(this._numberOfOH, this._minorityTransparency);
        } else {
            this.createOHNodes(this._numberOfOH, this._majorityTransparency);
            this.createH3ONodes(this._numberOfH3O, this._minorityTransparency);
        }
    }

    private int getNumberOfH3OParticles(double d) {
        return (int)(Liquid.getConcentrationH3O(d) * (double)(this._numberOfParticlesAtPH7 / 2) / 1.0E-7);
    }

    private int getNumberOfOHParticles(double d) {
        return (int)(Liquid.getConcentrationOH(d) * (double)(this._numberOfParticlesAtPH7 / 2) / 1.0E-7);
    }

    private void createH3ONodes(int n, int n2) {
        Point2D.Double double_ = new Point2D.Double();
        Color color = ColorUtils.createColor(this._h3oColor, n2);
        for (int i = 0; i < n; ++i) {
            this.getRandomPoint(this._containerBounds, double_);
            H3ONode h3ONode = new H3ONode(this._diameter, color);
            h3ONode.setOffset(double_);
            this._particlesParent.addChild(h3ONode);
        }
    }

    private void createOHNodes(int n, int n2) {
        Point2D.Double double_ = new Point2D.Double();
        Color color = ColorUtils.createColor(this._ohColor, n2);
        for (int i = 0; i < n; ++i) {
            this.getRandomPoint(this._containerBounds, double_);
            OHNode oHNode = new OHNode(this._diameter, color);
            oHNode.setOffset(double_);
            this._particlesParent.addChild(oHNode);
        }
    }

    private void getRandomPoint(PBounds pBounds, Point2D point2D) {
        double d = pBounds.getX() + this._randomCoordinate.nextDouble() * pBounds.getWidth();
        double d2 = pBounds.getY() + this._randomCoordinate.nextDouble() * pBounds.getHeight();
        point2D.setLocation(d, d2);
    }

    private static class H3ONode
    extends ParticleNode {
        public H3ONode(double d, Color color) {
            super(d, color);
        }
    }

    private static class OHNode
    extends ParticleNode {
        public OHNode(double d, Color color) {
            super(d, color);
        }
    }

    private static abstract class ParticleNode
    extends PPath {
        private Ellipse2D _ellipse = new Ellipse2D.Double();

        public ParticleNode(double d, Color color) {
            this.setPaint(color);
            this.setStroke(null);
            this.setDiameter(d);
        }

        public void setDiameter(double d) {
            this._ellipse.setFrame(-d / 2.0, -d / 2.0, d, d);
            this.setPathTo(this._ellipse);
        }
    }
}

