/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.common.phetcommon.util.ConstantPowerOfTenNumberFormat;
import edu.colorado.phet.common.phetcommon.util.TimesTenNumberFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.FormattedNumberNode;
import edu.colorado.phet.common.piccolophet.nodes.RectangularBackgroundNode;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.view.H2OMoleculeNode;
import edu.colorado.phet.phscale.view.H3OMoleculeNode;
import edu.colorado.phet.phscale.view.OHMoleculeNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.text.NumberFormat;

public class MoleculeCountNode
extends PComposite {
    private static final TimesTenNumberFormat H3O_FORMAT = new TimesTenNumberFormat("0.00");
    private static final TimesTenNumberFormat OH_FORMAT = new TimesTenNumberFormat("0.00");
    private static final ConstantPowerOfTenNumberFormat H2O_FORMAT = new ConstantPowerOfTenNumberFormat("0.0", 25);
    private static final Font VALUE_FONT = new PhetFont(1, 18);
    private static final Color VALUE_COLOR = Color.BLACK;
    private static final Color VALUE_BACKGROUND_COLOR = new Color(255, 255, 255, 128);
    private static final Insets VALUE_INSETS = new Insets(4, 4, 4, 4);
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private final ValueNode _h3oCountNode;
    private final ValueNode _ohCountNode;
    private final ValueNode _h2oCountNode;

    public MoleculeCountNode(Liquid liquid) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._liquid = liquid;
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                MoleculeCountNode.this.update();
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        H3OMoleculeNode h3OMoleculeNode = new H3OMoleculeNode();
        OHMoleculeNode oHMoleculeNode = new OHMoleculeNode();
        H2OMoleculeNode h2OMoleculeNode = new H2OMoleculeNode();
        this._h3oCountNode = new ValueNode(H3O_FORMAT);
        this._ohCountNode = new ValueNode(OH_FORMAT);
        this._h2oCountNode = new ValueNode(H2O_FORMAT);
        this.update();
        this.addChild(h3OMoleculeNode);
        this.addChild(oHMoleculeNode);
        this.addChild(h2OMoleculeNode);
        this.addChild(this._h3oCountNode);
        this.addChild(this._ohCountNode);
        this.addChild(this._h2oCountNode);
        h3OMoleculeNode.setOffset(0.0, 0.0);
        oHMoleculeNode.setOffset(h3OMoleculeNode.getFullBoundsReference().getX(), h3OMoleculeNode.getFullBoundsReference().getMaxY() + 20.0);
        h2OMoleculeNode.setOffset(oHMoleculeNode.getFullBoundsReference().getX(), oHMoleculeNode.getFullBoundsReference().getMaxY() + 20.0);
        PBounds pBounds = h3OMoleculeNode.getFullBoundsReference();
        PBounds pBounds2 = oHMoleculeNode.getFullBoundsReference();
        PBounds pBounds3 = h2OMoleculeNode.getFullBoundsReference();
        double d = Math.max(pBounds.getMaxX(), Math.max(pBounds2.getMaxX(), pBounds3.getMaxX()));
        this._h3oCountNode.setOffset(d + 10.0, pBounds.getCenterY() - this._h3oCountNode.getFullBoundsReference().getHeight() / 2.0);
        this._ohCountNode.setOffset(d + 10.0, pBounds2.getCenterY() - this._ohCountNode.getFullBoundsReference().getHeight() / 2.0);
        this._h2oCountNode.setOffset(d + 10.0, pBounds3.getCenterY() - this._h2oCountNode.getFullBoundsReference().getHeight() / 2.0);
    }

    private void update() {
        this._h3oCountNode.setValue(this._liquid.getMoleculesH3O());
        this._ohCountNode.setValue(this._liquid.getMoleculesOH());
        this._h2oCountNode.setValue(this._liquid.getMoleculesH2O());
    }

    private static class ValueNode
    extends PComposite {
        private FormattedNumberNode _numberNode;

        public ValueNode(NumberFormat numberFormat) {
            this._numberNode = new FormattedNumberNode(numberFormat, 0.0, VALUE_FONT, VALUE_COLOR);
            RectangularBackgroundNode rectangularBackgroundNode = new RectangularBackgroundNode(this._numberNode, VALUE_INSETS, VALUE_BACKGROUND_COLOR);
            this.addChild(rectangularBackgroundNode);
        }

        public void setValue(double d) {
            this._numberNode.setValue(d);
        }
    }
}

