/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.phscale.PHScaleApplication;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.model.LiquidDescriptor;
import edu.colorado.phet.phscale.view.beaker.ParticlesNode;
import edu.colorado.phet.phscale.view.beaker.VolumeValueNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PClip;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public class LiquidNode
extends PComposite {
    private static final LiquidDescriptor WATER = LiquidDescriptor.getWater();
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private final PDimension _maxSize;
    private final PPath _waterNode;
    private final Rectangle2D _liquidPath;
    private final PPath _liquidNode;
    private final ParticlesNode _particlesNode;
    private final PText _rgbaNode;
    private final VolumeValueNode _volumeValueNode;

    public LiquidNode(Liquid liquid, PDimension pDimension) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._liquid = liquid;
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                LiquidNode.this.update();
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        WATER.addLiquidDescriptorListener(new LiquidDescriptor.LiquidDescriptorAdapter(){

            public void colorChanged(Color color) {
                LiquidNode.this._waterNode.setPaint(WATER.getColor());
            }
        });
        this._maxSize = new PDimension(pDimension);
        this._waterNode = new PPath();
        this._waterNode.setPaint(LiquidDescriptor.getWater().getColor());
        this._waterNode.setStroke(null);
        this.addChild(this._waterNode);
        this._liquidPath = new Rectangle2D.Double();
        this._liquidNode = new PClip();
        this._liquidNode.setStroke(null);
        this.addChild(this._liquidNode);
        this._volumeValueNode = new VolumeValueNode();
        this._volumeValueNode.setOffset(pDimension.getWidth() + 3.0, 0.0);
        this.addChild(this._volumeValueNode);
        PBounds pBounds = new PBounds(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight());
        this._particlesNode = new ParticlesNode(this._liquid, pBounds);
        this._liquidNode.addChild(this._particlesNode);
        this._rgbaNode = new PText("Color=[255,255,255,255]");
        this._rgbaNode.setFont(new PhetFont());
        this._rgbaNode.setOffset(pDimension.getWidth() - this._rgbaNode.getWidth() - 15.0, pDimension.getHeight() - this._rgbaNode.getHeight() - 5.0);
        if (PHScaleApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addChild(this._rgbaNode);
        }
        this.update();
    }

    public void setParticlesVisible(boolean bl) {
        this._particlesNode.setVisible(bl);
    }

    public ParticlesNode getParticlesNode() {
        return this._particlesNode;
    }

    private void update() {
        Color color = this._liquid.getColor();
        this._liquidNode.setPaint(color);
        if (color != null) {
            this._rgbaNode.setText("Color=[" + color.getRed() + "," + color.getBlue() + "," + color.getGreen() + "," + color.getAlpha() + "]");
        } else {
            this._rgbaNode.setText("");
        }
        double d = this._liquid.getVolume() / this._liquid.getMaxVolume();
        double d2 = d * this._maxSize.getHeight();
        this._liquidPath.setRect(0.0, this._maxSize.getHeight() - d2, this._maxSize.getWidth(), d2);
        this._liquidNode.setPathTo(this._liquidPath);
        this._waterNode.setPathTo(this._liquidPath);
        this._volumeValueNode.setValue(this._liquid.getVolume());
        this._volumeValueNode.setOffset(this._volumeValueNode.getXOffset(), this._maxSize.getHeight() - d2);
    }
}

