/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.phscale.PHScaleApplication;
import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.model.LiquidDescriptor;
import edu.colorado.phet.phscale.view.beaker.ConfirmChangeLiquidDialog;
import edu.colorado.phet.phscale.view.beaker.FaucetControlNode;
import edu.colorado.phet.phscale.view.beaker.LiquidComboBox;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;

public class LiquidControlNode
extends PNode {
    private static final PDimension LIQUID_COLUMN_SIZE = PHScaleConstants.LIQUID_COLUMN_SIZE;
    private static final LiquidDescriptor WATER = LiquidDescriptor.getWater();
    private static final LiquidDescriptor.CustomLiquidDescriptor CUSTOM_LIQUID = LiquidDescriptor.getCustom();
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private final LiquidComboBox _comboBox;
    private final Rectangle2D _liquidColumnShape;
    private final PPath _liquidColumnNode;
    private final PPath _waterColumnNode;
    private final FaucetControlNode _faucetControlNode;
    private LiquidDescriptor _selectedLiquidDescriptor;
    private boolean _confirmChangeLiquid = false;
    private boolean _notifyEnabled = true;

    public LiquidControlNode(Liquid liquid, double d, PSwingCanvas pSwingCanvas) {
        this._liquid = liquid;
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                LiquidControlNode.this.update();
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        WATER.addLiquidDescriptorListener(new LiquidDescriptor.LiquidDescriptorAdapter(){

            public void colorChanged(Color color) {
                LiquidControlNode.this._waterColumnNode.setPaint(WATER.getColor());
            }
        });
        this._comboBox = new LiquidComboBox();
        this._comboBox.setChoice(this._liquid.getLiquidDescriptor());
        this._selectedLiquidDescriptor = this._comboBox.getChoice();
        this._comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && LiquidControlNode.this._notifyEnabled) {
                    LiquidControlNode.this.handleLiquidSelection(LiquidControlNode.this._confirmChangeLiquid);
                }
            }
        });
        PSwing pSwing = new PSwing(this._comboBox);
        pSwing.addInputEventListener(new CursorHandler());
        this._comboBox.setEnvironment(pSwing, pSwingCanvas);
        this._faucetControlNode = new FaucetControlNode(4, d);
        this._faucetControlNode.setEnabled(this._comboBox.getChoice() != null);
        this._faucetControlNode.addFaucetControlListener(new FaucetControlNode.FaucetControlListener(){

            public void valueChanged() {
                if (LiquidControlNode.this._notifyEnabled) {
                    LiquidControlNode.this._liquid.setLiquidFillRate(LiquidControlNode.this._faucetControlNode.getRate());
                }
            }
        });
        this._liquidColumnShape = new Rectangle2D.Double();
        this._liquidColumnNode = new PPath(this._liquidColumnShape);
        this._liquidColumnNode.setStroke(null);
        this._liquidColumnNode.setVisible(this._faucetControlNode.isOn());
        this._liquidColumnNode.setPickable(false);
        this._liquidColumnNode.setChildrenPickable(false);
        this._waterColumnNode = new PPath(this._liquidColumnShape);
        this._waterColumnNode.setPaint(WATER.getColor());
        this._waterColumnNode.setStroke(null);
        this._waterColumnNode.setVisible(this._faucetControlNode.isOn());
        this._waterColumnNode.setPickable(false);
        this._waterColumnNode.setChildrenPickable(false);
        this.addChild(pSwing);
        this.addChild(this._waterColumnNode);
        this.addChild(this._liquidColumnNode);
        this.addChild(this._faucetControlNode);
        pSwing.setOffset(0.0, 0.0);
        PBounds pBounds = pSwing.getFullBoundsReference();
        this._faucetControlNode.setOffset(pBounds.getX(), pBounds.getMaxY() + 5.0);
        this._liquidColumnNode.setOffset(this._faucetControlNode.getFullBoundsReference().getMaxX() - 18.0, this._faucetControlNode.getFullBoundsReference().getMaxY());
        this._waterColumnNode.setOffset(this._liquidColumnNode.getOffset());
        this.update();
    }

    private void update() {
        this._notifyEnabled = false;
        this._selectedLiquidDescriptor = this._liquid.getLiquidDescriptor();
        this._comboBox.setChoice(this._liquid.getLiquidDescriptor());
        this._faucetControlNode.setRate(this._liquid.getFillLiquidRate());
        this._faucetControlNode.setEnabled(!this._liquid.isFull());
        this._notifyEnabled = true;
        this._liquidColumnNode.setPaint(this._liquid.getLiquidDescriptor().getColor());
        this._liquidColumnNode.setVisible(this._liquid.isFillingLiquid());
        this._waterColumnNode.setVisible(this._liquid.isFillingLiquid());
        double d = this._faucetControlNode.getPercentOn();
        double d2 = 2.0 + d * (LIQUID_COLUMN_SIZE.getWidth() - 2.0);
        this._liquidColumnShape.setRect(-d2 / 2.0, 0.0, d2, LIQUID_COLUMN_SIZE.getHeight());
        this._liquidColumnNode.setPathTo(this._liquidColumnShape);
        this._waterColumnNode.setPathTo(this._liquidColumnShape);
    }

    private void handleLiquidSelection(boolean bl) {
        LiquidDescriptor liquidDescriptor = this._comboBox.getChoice();
        if (!liquidDescriptor.equals(this._selectedLiquidDescriptor)) {
            if (liquidDescriptor.equals(CUSTOM_LIQUID)) {
                CUSTOM_LIQUID.resetPH();
            }
            boolean bl2 = true;
            if (!this._liquid.isEmpty() && bl) {
                bl2 = this.confirmChangeLiquid();
            }
            if (bl2) {
                this._selectedLiquidDescriptor = liquidDescriptor;
                this._liquid.setLiquidDescriptor(liquidDescriptor);
            } else {
                this._comboBox.setChoice(this._selectedLiquidDescriptor);
            }
        }
    }

    private boolean confirmChangeLiquid() {
        PhetFrame phetFrame = PHScaleApplication.getInstance().getPhetFrame();
        ConfirmChangeLiquidDialog confirmChangeLiquidDialog = new ConfirmChangeLiquidDialog(phetFrame);
        SwingUtils.centerDialogInParent(confirmChangeLiquidDialog);
        confirmChangeLiquidDialog.setVisible(true);
        boolean bl = confirmChangeLiquidDialog.isConfirmed();
        this._confirmChangeLiquid = !confirmChangeLiquidDialog.getDontAskAgain();
        return bl;
    }
}

