/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class FaucetSliderNode
extends PNode {
    private static final Stroke TRACK_STROKE = new BasicStroke(2.0f);
    private static final Color TRACK_STROKE_COLOR = Color.BLACK;
    private static final Color TRACK_FILL_COLOR = Color.LIGHT_GRAY;
    private static final Stroke KNOB_STROKE = new BasicStroke(1.0f);
    private static final Color KNOB_FILL_COLOR = new Color(255, 255, 255, 210);
    private static final Color KNOB_STROKE_COLOR = Color.BLACK;
    private final ArrayList _listeners = new ArrayList();
    private final double _maxRate;
    private final PDimension _trackSize;
    private final KnobNode _knobNode;
    private double _value;
    private boolean _dragging = false;

    public FaucetSliderNode(double d, PDimension pDimension, PDimension pDimension2) {
        this._maxRate = d;
        this._trackSize = new PDimension(pDimension);
        TrackNode trackNode = new TrackNode(pDimension);
        this._knobNode = new KnobNode(pDimension2);
        this.addChild(trackNode);
        this.addChild(this._knobNode);
        this._value = 0.0;
        trackNode.setOffset(0.0, 0.0);
        this._knobNode.setOffset(0.0, trackNode.getFullBoundsReference().getCenterY() + this._knobNode.getFullBoundsReference().getHeight() / 2.0);
        this._knobNode.addInputEventListener(new CursorHandler());
        this.initInteractivity();
    }

    private void initInteractivity() {
        this._knobNode.addInputEventListener(new CursorHandler());
        this._knobNode.addInputEventListener(new PDragEventHandler(){
            private double _globalClickYOffset;

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                FaucetSliderNode.this._dragging = true;
                Point2D point2D = pInputEvent.getPositionRelativeTo(FaucetSliderNode.this);
                Point2D point2D2 = FaucetSliderNode.this.localToGlobal(point2D);
                Point2D point2D3 = FaucetSliderNode.this.localToGlobal(FaucetSliderNode.this._knobNode.getOffset());
                this._globalClickYOffset = point2D2.getY() - point2D3.getY();
            }

            protected void drag(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getPositionRelativeTo(FaucetSliderNode.this);
                Point2D point2D2 = FaucetSliderNode.this.localToGlobal(point2D);
                Point2D.Double double_ = new Point2D.Double(point2D2.getX(), point2D2.getY() - this._globalClickYOffset);
                Point2D point2D3 = FaucetSliderNode.this.globalToLocal(double_);
                double d = point2D3.getX();
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > FaucetSliderNode.this._trackSize.getWidth()) {
                    d = FaucetSliderNode.this._trackSize.getWidth();
                }
                FaucetSliderNode.this._knobNode.setOffset(d, FaucetSliderNode.this._knobNode.getYOffset());
                double d2 = FaucetSliderNode.this.viewToModel(d);
                FaucetSliderNode.this.setRate(d2);
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                FaucetSliderNode.this._dragging = false;
                FaucetSliderNode.this.setRate(0.0);
            }
        });
    }

    public void setRate(double d) {
        if (d < 0.0 || d > this._maxRate) {
            throw new IllegalArgumentException("value is out of range");
        }
        if (!this._dragging) {
            double d2 = this.modelToView(d);
            this._knobNode.setOffset(d2, this._knobNode.getYOffset());
        }
        if (d != this._value) {
            this._value = d;
            this.notifyValueChanged();
        }
    }

    public double getRate() {
        return this._value;
    }

    public boolean isOn() {
        return this._value == 0.0;
    }

    public double getPercentOn() {
        return this._value / this._maxRate;
    }

    private double modelToView(double d) {
        assert (d >= 0.0 && d <= this._maxRate);
        return this._trackSize.getWidth() * d / this._maxRate;
    }

    private double viewToModel(double d) {
        return this._maxRate * d / this._trackSize.getWidth();
    }

    public void addFaucetSliderListener(FaucetSliderListener faucetSliderListener) {
        this._listeners.add(faucetSliderListener);
    }

    private void notifyValueChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((FaucetSliderListener)iterator.next()).valueChanged();
        }
    }

    public static interface FaucetSliderListener {
        public void valueChanged();
    }

    private static class KnobNode
    extends PNode {
        public KnobNode(PDimension pDimension) {
            float f = (float)pDimension.getWidth();
            float f2 = (float)pDimension.getHeight();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(f / 2.0f, -0.35f * f2);
            generalPath.lineTo(f / 2.0f, -f2);
            generalPath.lineTo(-f / 2.0f, -f2);
            generalPath.lineTo(-f / 2.0f, -0.35f * f2);
            generalPath.closePath();
            PPath pPath = new PPath();
            pPath.setPathTo(generalPath);
            pPath.setPaint(KNOB_FILL_COLOR);
            pPath.setStroke(KNOB_STROKE);
            pPath.setStrokePaint(KNOB_STROKE_COLOR);
            this.addChild(pPath);
        }
    }

    private static class TrackNode
    extends PNode {
        public TrackNode(PDimension pDimension) {
            PPath pPath = new PPath();
            double d = pDimension.getWidth() - 2.0;
            double d2 = pDimension.getHeight() - 2.0;
            pPath.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, d2));
            pPath.setPaint(TRACK_FILL_COLOR);
            pPath.setStroke(TRACK_STROKE);
            pPath.setStrokePaint(TRACK_STROKE_COLOR);
            this.addChild(pPath);
        }
    }
}

