/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.phscale.view.beaker.FaucetNode;
import edu.colorado.phet.phscale.view.beaker.FaucetSliderNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.util.ArrayList;
import java.util.Iterator;

public class FaucetControlNode
extends PNode {
    public static final PDimension SLIDER_TRACK_SIZE = new PDimension(75.0, 6.0);
    public static final PDimension SLIDER_KNOB_SIZE = new PDimension(15.0, 20.0);
    private final FaucetSliderNode _sliderNode;
    private final ArrayList _listeners = new ArrayList();
    private boolean _enabled = true;

    public FaucetControlNode(int n, double d) {
        FaucetNode faucetNode = new FaucetNode(n);
        faucetNode.setPickable(false);
        faucetNode.setChildrenPickable(false);
        this._sliderNode = new FaucetSliderNode(d, SLIDER_TRACK_SIZE, SLIDER_KNOB_SIZE);
        this._sliderNode.addFaucetSliderListener(new FaucetSliderNode.FaucetSliderListener(){

            public void valueChanged() {
                if (FaucetControlNode.this._enabled) {
                    FaucetControlNode.this.notifyValueChanged();
                }
            }
        });
        this.addChild(faucetNode);
        this.addChild(this._sliderNode);
        this._sliderNode.setOffset(26.0, 0.55 * faucetNode.getFullBoundsReference().getHeight());
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public void setRate(double d) {
        this._sliderNode.setRate(d);
    }

    public double getRate() {
        double d = 0.0;
        if (this._enabled) {
            d = this._sliderNode.getRate();
        }
        return d;
    }

    public boolean isOn() {
        boolean bl = false;
        if (this._enabled) {
            bl = this._sliderNode.isOn();
        }
        return bl;
    }

    public double getPercentOn() {
        double d = 0.0;
        if (this._enabled) {
            d = this._sliderNode.getPercentOn();
        }
        return d;
    }

    public void addFaucetControlListener(FaucetControlListener faucetControlListener) {
        this._listeners.add(faucetControlListener);
    }

    private void notifyValueChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((FaucetControlListener)iterator.next()).valueChanged();
        }
    }

    public static interface FaucetControlListener {
        public void valueChanged();
    }
}

