/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.model.LiquidDescriptor;
import edu.colorado.phet.phscale.view.beaker.FaucetControlNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class DrainControlNode
extends PNode {
    private static final PDimension LIQUID_COLUMN_SIZE = PHScaleConstants.LIQUID_COLUMN_SIZE;
    private static final Color PIPE_FILL_COLOR = new Color(233, 184, 0);
    private static final Color PIPE_STROKE_COLOR = Color.BLACK;
    private static final Stroke PIPE_STROKE = new BasicStroke(2.0f);
    private static final LiquidDescriptor WATER = LiquidDescriptor.getWater();
    private final FaucetControlNode _faucetControlNode;
    private final Rectangle2D _liquidColumnShape;
    private final PPath _liquidColumnNode;
    private final PPath _waterColumnNode;
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private boolean _notifyEnabled = true;

    public DrainControlNode(Liquid liquid, double d) {
        this._liquid = liquid;
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                DrainControlNode.this.update();
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        WATER.addLiquidDescriptorListener(new LiquidDescriptor.LiquidDescriptorAdapter(){

            public void colorChanged(Color color) {
                DrainControlNode.this._waterColumnNode.setPaint(WATER.getColor());
            }
        });
        this._faucetControlNode = new FaucetControlNode(2, d);
        this._faucetControlNode.addFaucetControlListener(new FaucetControlNode.FaucetControlListener(){

            public void valueChanged() {
                if (DrainControlNode.this._notifyEnabled) {
                    DrainControlNode.this._liquid.setDrainRate(DrainControlNode.this._faucetControlNode.getRate());
                }
            }
        });
        this._liquidColumnShape = new Rectangle2D.Double();
        this._liquidColumnNode = new PPath(this._liquidColumnShape);
        this._liquidColumnNode.setStroke(null);
        this._liquidColumnNode.setVisible(this._faucetControlNode.isOn());
        this._liquidColumnNode.setPickable(false);
        this._liquidColumnNode.setChildrenPickable(false);
        this._waterColumnNode = new PPath(this._liquidColumnShape);
        this._waterColumnNode.setPaint(WATER.getColor());
        this._waterColumnNode.setStroke(null);
        this._waterColumnNode.setVisible(this._faucetControlNode.isOn());
        this._waterColumnNode.setPickable(false);
        this._waterColumnNode.setChildrenPickable(false);
        Shape shape = this.createPipeShape();
        PPath pPath = new PPath(shape);
        pPath.setPaint(PIPE_FILL_COLOR);
        pPath.setStrokePaint(PIPE_STROKE_COLOR);
        pPath.setStroke(PIPE_STROKE);
        pPath.setPickable(false);
        pPath.setChildrenPickable(false);
        this.addChild(pPath);
        this.addChild(this._waterColumnNode);
        this.addChild(this._liquidColumnNode);
        this.addChild(this._faucetControlNode);
        this._faucetControlNode.setOffset(0.0, 0.0);
        this._liquidColumnNode.setOffset(this._faucetControlNode.getFullBoundsReference().getMinX() + 18.0, this._faucetControlNode.getFullBoundsReference().getMaxY() - 2.0);
        this._waterColumnNode.setOffset(this._liquidColumnNode.getOffset());
        pPath.setOffset(this._faucetControlNode.getFullBoundsReference().getMaxX() - 2.0, 37.0);
        this.update();
    }

    private void update() {
        this._notifyEnabled = false;
        this._faucetControlNode.setRate(this._liquid.getDrainRate());
        this._faucetControlNode.setEnabled(!this._liquid.isEmpty());
        this._notifyEnabled = true;
        this._liquidColumnNode.setPaint(this._liquid.getColor());
        this._liquidColumnNode.setVisible(this._liquid.isDraining());
        this._waterColumnNode.setVisible(this._liquid.isDraining());
        double d = this._faucetControlNode.getPercentOn();
        double d2 = 2.0 + d * (LIQUID_COLUMN_SIZE.getWidth() - 2.0);
        this._liquidColumnShape.setRect(-d2 / 2.0, 0.0, d2, LIQUID_COLUMN_SIZE.getHeight());
        this._liquidColumnNode.setPathTo(this._liquidColumnShape);
        this._waterColumnNode.setPathTo(this._liquidColumnShape);
    }

    private Shape createPipeShape() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 40.0, 31.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(20.0, -50.0, 31.0, 70.0);
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(20.0, 0.0, 31.0, 31.0, 20.0, 20.0);
        Area area = new Area(double_);
        area.add(new Area(double_2));
        area.add(new Area(double_3));
        return area;
    }
}

