/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.phscale.PHScaleStrings;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class BeakerNode
extends PComposite {
    private static final String[] MAJOR_TICK_LABELS = new String[]{"\u00bd", "1"};
    private static final Color TICK_COLOR = Color.BLACK;
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(2.0f, 0, 2);
    private static final Stroke MINOR_TICK_STROKE = new BasicStroke(2.0f, 0, 2);
    private static final Font TICK_LABEL_FONT = new PhetFont(20);
    private static final Stroke OUTLINE_STROKE = new BasicStroke(6.0f, 1, 1);
    private static final Color OUTLINE_COLOR = Color.BLACK;
    private static final Point2D BEAKER_LIP_OFFSET = new Point2D.Double(20.0, 20.0);
    private final GeneralPath _beakerPath;
    private final PPath _beakerNode;

    public BeakerNode(PDimension pDimension, double d) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        float f = (float)pDimension.getWidth();
        float f2 = (float)pDimension.getHeight();
        this._beakerPath = new GeneralPath();
        this._beakerPath.reset();
        this._beakerPath.moveTo((float)(-BEAKER_LIP_OFFSET.getX()), (float)(-(BEAKER_LIP_OFFSET.getY() + 10.0)));
        this._beakerPath.lineTo(0.0f, -10.0f);
        this._beakerPath.lineTo(0.0f, f2);
        this._beakerPath.lineTo(f, f2);
        this._beakerPath.lineTo(f, -10.0f);
        this._beakerPath.lineTo((float)((double)f + BEAKER_LIP_OFFSET.getX()), (float)(-(BEAKER_LIP_OFFSET.getY() + 10.0)));
        this._beakerNode = new PPath(this._beakerPath);
        this._beakerNode.setPaint(null);
        this._beakerNode.setStroke(OUTLINE_STROKE);
        this._beakerNode.setStrokePaint(OUTLINE_COLOR);
        this.addChild(this._beakerNode);
        PComposite pComposite = new PComposite();
        this.addChild(pComposite);
        int n = (int)Math.round(d / 0.1);
        double d2 = pDimension.getWidth();
        double d3 = pDimension.getHeight();
        double d4 = pDimension.getHeight() / (double)n;
        for (int i = 1; i <= n; ++i) {
            PPath pPath;
            Line2D.Double double_;
            double d5 = d3 - (double)i * d4;
            if (i % 5 == 0) {
                double_ = new Line2D.Double(d2 - 20.0, d5, d2 - 2.0, d5);
                pPath = new PPath(double_);
                pPath.setStroke(MAJOR_TICK_STROKE);
                pPath.setStrokePaint(TICK_COLOR);
                pComposite.addChild(pPath);
                int n2 = i / 5 - 1;
                if (n2 >= MAJOR_TICK_LABELS.length) continue;
                String string = MAJOR_TICK_LABELS[n2] + PHScaleStrings.UNITS_LITERS;
                PText pText = new PText(string);
                pText.setFont(TICK_LABEL_FONT);
                pText.setTextPaint(TICK_COLOR);
                pComposite.addChild(pText);
                double d6 = pPath.getFullBounds().getMinX() - pText.getFullBoundsReference().getWidth() - 8.0;
                double d7 = pPath.getFullBounds().getMinY() - pText.getFullBoundsReference().getHeight() / 2.0;
                pText.setOffset(d6, d7);
                continue;
            }
            double_ = new Line2D.Double(d2 - 12.0, d5, d2 - 2.0, d5);
            pPath = new PPath(double_);
            pPath.setStroke(MINOR_TICK_STROKE);
            pPath.setStrokePaint(TICK_COLOR);
            pComposite.addChild(pPath);
        }
    }

    public static Point2D getLipOffset() {
        return BEAKER_LIP_OFFSET;
    }
}

