/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.view.beaker;

import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.model.LiquidDescriptor;
import edu.colorado.phet.phscale.view.beaker.BeakerNode;
import edu.colorado.phet.phscale.view.beaker.DrainControlNode;
import edu.colorado.phet.phscale.view.beaker.LiquidControlNode;
import edu.colorado.phet.phscale.view.beaker.LiquidNode;
import edu.colorado.phet.phscale.view.beaker.MoleculeCountNode;
import edu.colorado.phet.phscale.view.beaker.ParticlesNode;
import edu.colorado.phet.phscale.view.beaker.ProbeNode;
import edu.colorado.phet.phscale.view.beaker.ViewControlPanel;
import edu.colorado.phet.phscale.view.beaker.WaterControlNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;

public class BeakerControlNode
extends PNode {
    private static final LiquidDescriptor.CustomLiquidDescriptor CUSTOM_LIQUID = LiquidDescriptor.getCustom();
    private final Liquid _liquid;
    private final Liquid.LiquidListener _liquidListener;
    private final LiquidControlNode _liquidControlNode;
    private final WaterControlNode _waterControlNode;
    private final BeakerNode _beakerNode;
    private final LiquidNode _liquidNode;
    private final ProbeNode _probeNode;
    private final MoleculeCountNode _moleculeCountNode;
    private final ViewControlPanel _viewControlPanel;
    private final DrainControlNode _drainControlNode;

    public BeakerControlNode(Liquid liquid, PSwingCanvas pSwingCanvas) {
        this._liquid = liquid;
        this._probeNode = new ProbeNode(PHScaleConstants.PH_PROBE_LENGTH, liquid);
        this._liquidControlNode = new LiquidControlNode(liquid, 0.1, pSwingCanvas);
        this._waterControlNode = new WaterControlNode(liquid, 0.1);
        this._drainControlNode = new DrainControlNode(liquid, 0.1);
        this._liquidNode = new LiquidNode(liquid, PHScaleConstants.BEAKER_SIZE);
        this._beakerNode = new BeakerNode(PHScaleConstants.BEAKER_SIZE, liquid.getMaxVolume());
        this._moleculeCountNode = new MoleculeCountNode(liquid);
        this._liquidListener = new Liquid.LiquidListener(){

            public void stateChanged() {
                BeakerControlNode.this._waterControlNode.setVisible(!BeakerControlNode.this._liquid.getLiquidDescriptor().equals(CUSTOM_LIQUID));
            }
        };
        this._liquid.addLiquidListener(this._liquidListener);
        this._viewControlPanel = new ViewControlPanel();
        PSwing pSwing = new PSwing(this._viewControlPanel);
        this._viewControlPanel.addViewControlPanelListener(new ViewControlPanel.ViewControlPanelListener(){

            public void countChanged(boolean bl) {
                BeakerControlNode.this._moleculeCountNode.setVisible(bl);
            }

            public void ratioChanged(boolean bl) {
                BeakerControlNode.this._liquidNode.setParticlesVisible(bl);
            }
        });
        this.addChild(this._liquidControlNode);
        this.addChild(this._waterControlNode);
        this.addChild(this._probeNode);
        this.addChild(this._drainControlNode);
        this.addChild(this._liquidNode);
        this.addChild(this._beakerNode);
        this.addChild(this._moleculeCountNode);
        this.addChild(pSwing);
        this._liquidControlNode.setOffset(0.0, 0.0);
        this._beakerNode.setOffset(BeakerNode.getLipOffset().getX(), this._liquidControlNode.getFullBoundsReference().getMaxY() - this._beakerNode.getFullBounds().getHeight() + 2.0 * BeakerNode.getLipOffset().getY());
        this._liquidNode.setOffset(this._beakerNode.getOffset());
        this._waterControlNode.setOffset(this._beakerNode.getFullBoundsReference().getWidth() - this._waterControlNode.getFullBoundsReference().getWidth() + BeakerNode.getLipOffset().getX(), this._liquidControlNode.getFullBoundsReference().getMaxY() - this._waterControlNode.getFullBoundsReference().getHeight());
        this._probeNode.setOffset(this._beakerNode.getFullBoundsReference().getCenterX() - this._probeNode.getFullBoundsReference().getWidth() / 2.0, this._beakerNode.getFullBoundsReference().getMaxY() - this._probeNode.getFullBoundsReference().getHeight());
        this._moleculeCountNode.setOffset(this._beakerNode.getFullBoundsReference().getX() + 50.0, this._beakerNode.getFullBoundsReference().getCenterY() - this._moleculeCountNode.getFullBoundsReference().getHeight() / 2.0);
        this._drainControlNode.setOffset(10.0, this._beakerNode.getFullBoundsReference().getMaxY() + 12.0);
        pSwing.setOffset(this._drainControlNode.getFullBoundsReference().getMaxX() + 30.0, this._beakerNode.getFullBoundsReference().getMaxY() + 20.0);
    }

    public void setMoleculeCountSelected(boolean bl) {
        this._viewControlPanel.setCountSelected(bl);
        this._moleculeCountNode.setVisible(bl);
    }

    public void setRatioSelected(boolean bl) {
        this._viewControlPanel.setRatioSelected(bl);
        this._liquidNode.setParticlesVisible(bl);
    }

    public ParticlesNode dev_getParticlesNode() {
        return this._liquidNode.getParticlesNode();
    }
}

