/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.model;

import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.PHScaleStrings;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class LiquidDescriptor {
    private static final DecimalFormat PH_FORMAT = new DecimalFormat("0.0");
    private static final LiquidDescriptor DRAIN_CLEANER = new LiquidDescriptor(PHScaleStrings.CHOICE_DRAIN_CLEANER, 13.0, new Color(255, 255, 0, 150));
    private static final LiquidDescriptor HAND_SOAP = new LiquidDescriptor(PHScaleStrings.CHOICE_HAND_SOAP, 10.0, new Color(204, 0, 204, 90));
    private static final LiquidDescriptor BLOOD = new LiquidDescriptor(PHScaleStrings.CHOICE_BLOOD, 7.4, new Color(185, 12, 0, 150));
    private static final LiquidDescriptor SPIT = new LiquidDescriptor(PHScaleStrings.CHOICE_SPIT, 7.4, new Color(204, 204, 198, 73));
    private static final LiquidDescriptor WATER = new LiquidDescriptor(PHScaleStrings.CHOICE_WATER, 7.0, ColorUtils.createColor(PHScaleConstants.H2O_COLOR, 127));
    private static final LiquidDescriptor MILK = new LiquidDescriptor(PHScaleStrings.CHOICE_MILK, 6.5, new Color(255, 255, 255, 156));
    private static final LiquidDescriptor COFFEE = new LiquidDescriptor(PHScaleStrings.CHOICE_COFFEE, 5.0, new Color(164, 99, 7, 127));
    private static final LiquidDescriptor BEER = new LiquidDescriptor(PHScaleStrings.CHOICE_BEER, 4.5, new Color(255, 200, 0, 127));
    private static final LiquidDescriptor LIME_SODA = new LiquidDescriptor(PHScaleStrings.SODA, 2.5, new Color(204, 255, 102, 162));
    private static final LiquidDescriptor VOMIT = new LiquidDescriptor(PHScaleStrings.CHOICE_VOMIT, 2.0, new Color(255, 171, 120, 183));
    private static final LiquidDescriptor BATTERY_ACID = new LiquidDescriptor(PHScaleStrings.CHOICE_BATTERY_ACID, 1.0, new Color(255, 255, 0, 127));
    private static final CustomLiquidDescriptor CUSTOM = new CustomLiquidDescriptor();
    private static final LiquidDescriptor[] ALL_INSTANCES = new LiquidDescriptor[]{DRAIN_CLEANER, HAND_SOAP, BLOOD, SPIT, WATER, MILK, COFFEE, BEER, LIME_SODA, VOMIT, BATTERY_ACID, CUSTOM};
    private final String _name;
    private double _pH;
    private Color _color;
    private final ArrayList _listeners;

    protected LiquidDescriptor(String string, double d, Color color) {
        this._name = string;
        this._pH = d;
        this._color = color;
        this._listeners = new ArrayList();
    }

    public static LiquidDescriptor[] getAllInstances() {
        return ALL_INSTANCES;
    }

    public static LiquidDescriptor getWater() {
        return WATER;
    }

    public static CustomLiquidDescriptor getCustom() {
        return CUSTOM;
    }

    public static LiquidDescriptor getDefaultLiquid() {
        return MILK;
    }

    public String getName() {
        return this._name;
    }

    protected void setPH(double d) {
        if (d != this._pH) {
            this._pH = d;
            this.notifyPHChanged(d);
        }
    }

    public double getPH() {
        return this._pH;
    }

    public Color getColor() {
        return this._color;
    }

    public void dev_setColor(Color color) {
        if (!color.equals(this._color)) {
            this._color = color;
            this.notifyColorChanged(color);
        }
    }

    public String toString() {
        return this._name + " (" + PH_FORMAT.format(this._pH) + ")";
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LiquidDescriptor) {
            LiquidDescriptor liquidDescriptor = (LiquidDescriptor)object;
            bl = this.getName().equals(liquidDescriptor.getName()) && this.getPH() == liquidDescriptor.getPH();
        }
        return bl;
    }

    public void addLiquidDescriptorListener(LiquidDescriptorListener liquidDescriptorListener) {
        this._listeners.add(liquidDescriptorListener);
    }

    public void removeLiquidDescriptorListener(LiquidDescriptorListener liquidDescriptorListener) {
        this._listeners.remove(liquidDescriptorListener);
    }

    private void notifyPHChanged(double d) {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((LiquidDescriptorListener)iterator.next()).pHChanged(d);
        }
    }

    private void notifyColorChanged(Color color) {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((LiquidDescriptorListener)iterator.next()).colorChanged(color);
        }
    }

    public static class CustomLiquidDescriptor
    extends LiquidDescriptor {
        private final double _defaultPH = this.getPH();

        private CustomLiquidDescriptor() {
            super(PHScaleStrings.CHOICE_CUSTOM, 7.0, new Color(255, 255, 156, 127));
        }

        public void setPH(double d) {
            super.setPH(d);
        }

        public void resetPH() {
            this.setPH(this._defaultPH);
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class LiquidDescriptorAdapter
    implements LiquidDescriptorListener {
        public void pHChanged(double d) {
        }

        public void colorChanged(Color color) {
        }
    }

    public static interface LiquidDescriptorListener {
        public void pHChanged(double var1);

        public void colorChanged(Color var1);
    }
}

