/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.phscale.model.LiquidDescriptor;
import edu.colorado.phet.phscale.model.PHValue;
import edu.colorado.phet.phscale.model.VolumeValue;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

public class Liquid
extends ClockAdapter {
    private static final LiquidDescriptor WATER = LiquidDescriptor.getWater();
    private static final LiquidDescriptor.CustomLiquidDescriptor CUSTOM_LIQUID = LiquidDescriptor.getCustom();
    private final ArrayList _listeners;
    private final IntegerRange _pHRange;
    private LiquidDescriptor _liquidDescriptor;
    private final LiquidDescriptor.LiquidDescriptorListener _liquidDescriptorListener;
    private PHValue _pH;
    private double _liquidVolume;
    private double _waterVolume;
    private double _fillVolume;
    private double _liquidFillRate;
    private double _waterFillRate;
    private double _drainRate;

    public Liquid(IntegerRange integerRange, LiquidDescriptor liquidDescriptor) {
        this._pHRange = new IntegerRange(integerRange);
        this._listeners = new ArrayList();
        this._liquidDescriptorListener = new LiquidDescriptor.LiquidDescriptorAdapter(){

            public void colorChanged(Color color) {
                Liquid.this.notifyStateChanged();
            }
        };
        WATER.addLiquidDescriptorListener(new LiquidDescriptor.LiquidDescriptorAdapter(){

            public void colorChanged(Color color) {
                if (Liquid.this._waterVolume > 0.0) {
                    Liquid.this.notifyStateChanged();
                }
            }
        });
        this._pH = null;
        this._liquidVolume = 0.0;
        this._waterVolume = 0.0;
        this._fillVolume = 1.2;
        this._liquidFillRate = 0.0;
        this._waterFillRate = 0.0;
        this._drainRate = 0.0;
        this.setLiquidDescriptor(liquidDescriptor);
    }

    public IntegerRange getPHRange() {
        return this._pHRange;
    }

    public void setLiquidDescriptor(LiquidDescriptor liquidDescriptor) {
        if (this._liquidDescriptor != null) {
            this._liquidDescriptor.removeLiquidDescriptorListener(this._liquidDescriptorListener);
        }
        this._liquidDescriptor = liquidDescriptor;
        this._liquidDescriptor.addLiquidDescriptorListener(this._liquidDescriptorListener);
        this.drainImmediately();
        this.setLiquidFillRate(0.075, 1.0);
        this.notifyStateChanged();
    }

    public LiquidDescriptor getLiquidDescriptor() {
        return this._liquidDescriptor;
    }

    public void setPH(double d) {
        if (!this._liquidDescriptor.equals(CUSTOM_LIQUID)) {
            this.setLiquidDescriptor(CUSTOM_LIQUID);
        }
        double d2 = d;
        if (d < (double)this._pHRange.getMin()) {
            d2 = this._pHRange.getMin();
        } else if (d > (double)this._pHRange.getMax()) {
            d2 = this._pHRange.getMax();
        }
        if (this._liquidDescriptor.equals(CUSTOM_LIQUID)) {
            CUSTOM_LIQUID.setPH(d2);
        }
        if (this._pH != null && d != this._pH.getValue()) {
            this._pH = new PHValue(d2);
            this.notifyStateChanged();
        }
    }

    public PHValue getPH() {
        return this._pH;
    }

    public double getVolume() {
        return new VolumeValue(this._liquidVolume + this._waterVolume).getValue();
    }

    public double getMaxVolume() {
        return 1.2;
    }

    public boolean isEmpty() {
        return this.getVolume() == 0.0;
    }

    public boolean isFull() {
        return this.getVolume() == 1.2;
    }

    public Color getColor() {
        Color color = null;
        double d = this.getVolume();
        if (d > 0.0) {
            if (this._liquidVolume == 0.0) {
                color = WATER.getColor();
            } else if (this._waterVolume == 0.0) {
                color = this._liquidDescriptor.getColor();
            } else {
                int n = (int)((double)this._liquidDescriptor.getColor().getAlpha() * (this._liquidVolume / d));
                color = ColorUtils.createColor(this._liquidDescriptor.getColor(), n);
            }
        }
        return color;
    }

    public void setLiquidFillRate(double d) {
        this.setLiquidFillRate(d, 1.2);
    }

    private void setLiquidFillRate(double d, double d2) {
        if (d != this._liquidFillRate || d2 != this._fillVolume) {
            this._liquidFillRate = d;
            this._fillVolume = d2;
            this.notifyStateChanged();
        }
    }

    public double getFillLiquidRate() {
        return this._liquidFillRate;
    }

    public void stopFillingLiquid() {
        this.setLiquidFillRate(0.0);
    }

    public boolean isFillingLiquid() {
        return this._liquidFillRate != 0.0;
    }

    public void setWaterFillRate(double d) {
        if (d != this._waterFillRate) {
            this._waterFillRate = d;
            this.notifyStateChanged();
        }
    }

    public double getWaterFillRate() {
        return this._waterFillRate;
    }

    public void stopFillingWater() {
        this.setWaterFillRate(0.0);
    }

    public boolean isFillingWater() {
        return this._waterFillRate != 0.0;
    }

    public void drainImmediately() {
        if (!this.isEmpty()) {
            this._liquidVolume = 0.0;
            this._waterVolume = 0.0;
            this._drainRate = 0.0;
            this.notifyStateChanged();
        }
    }

    public void setDrainRate(double d) {
        if (d != this._drainRate) {
            this._drainRate = d;
            this.notifyStateChanged();
        }
    }

    public double getDrainRate() {
        return this._drainRate;
    }

    public void stopDraining() {
        this.setDrainRate(0.0);
    }

    public boolean isDraining() {
        return this._drainRate != 0.0;
    }

    public void setConcentrationH3O(double d) {
        this.setPH(-MathUtil.log10(d));
    }

    public double getConcentrationH3O() {
        double d = 0.0;
        if (this._pH != null) {
            d = Liquid.getConcentrationH3O(this._pH.getValue());
        }
        return d;
    }

    public static double getConcentrationH3O(double d) {
        return Math.pow(10.0, -d);
    }

    public void setConcentrationOH(double d) {
        this.setPH(14.0 - -MathUtil.log10(d));
    }

    public double getConcentrationOH() {
        double d = 0.0;
        if (this._pH != null) {
            d = Liquid.getConcentrationOH(this._pH.getValue());
        }
        return d;
    }

    public static double getConcentrationOH(double d) {
        return Math.pow(10.0, -(14.0 - d));
    }

    public double getConcentrationH2O() {
        return this.isEmpty() ? 0.0 : 55.0;
    }

    public double getMoleculesH3O() {
        return this.getConcentrationH3O() * 6.023E23 * this.getVolume();
    }

    public double getMoleculesOH() {
        return this.getConcentrationOH() * 6.023E23 * this.getVolume();
    }

    public double getMoleculesH2O() {
        return this.getConcentrationH2O() * 6.023E23 * this.getVolume();
    }

    public void setMolesH3O(double d) {
        this.setPH(-MathUtil.log10(d / this.getVolume()));
    }

    public double getMolesH3O() {
        return this.getVolume() * this.getConcentrationH3O();
    }

    public void setMolesOH(double d) {
        this.setPH(14.0 - -MathUtil.log10(d / this.getVolume()));
    }

    public double getMolesOH() {
        return this.getVolume() * this.getConcentrationOH();
    }

    public double getMolesH2O() {
        return this.getVolume() * this.getConcentrationH2O();
    }

    public void clockTicked(ClockEvent clockEvent) {
        if (this.isFillingLiquid()) {
            this.stepFillLiquid();
        }
        if (this.isFillingWater()) {
            this.stepFillWater();
        }
        if (this.isDraining()) {
            this.stepDrain();
        }
    }

    private void stepFillLiquid() {
        double d = this.getVolume();
        double d2 = Math.min(this._liquidFillRate, this._fillVolume - d);
        this._liquidVolume += d2;
        if (this.getVolume() >= this._fillVolume) {
            this.stopFillingLiquid();
        }
        this.updatePH();
    }

    private void stepFillWater() {
        double d = this.getVolume();
        double d2 = Math.min(this._waterFillRate, this._fillVolume - d);
        this._waterVolume += d2;
        if (this.getVolume() >= this._fillVolume) {
            this.stopFillingWater();
        }
        this.updatePH();
    }

    private void stepDrain() {
        double d = this.getVolume();
        double d2 = Math.min(this._drainRate, d);
        this._waterVolume = Math.max(0.0, this._waterVolume - d2 * this._waterVolume / d);
        this._liquidVolume = Math.max(0.0, this._liquidVolume - d2 * this._liquidVolume / d);
        if (this.getVolume() <= 0.0) {
            this.stopDraining();
        }
        this.updatePH();
    }

    private void updatePH() {
        this._pH = this.getVolume() == 0.0 ? null : (this._waterVolume == 0.0 ? new PHValue(this._liquidDescriptor.getPH()) : (this._liquidVolume == 0.0 ? new PHValue(WATER.getPH()) : new PHValue(Liquid.pHCombined(this._liquidDescriptor.getPH(), this._liquidVolume, WATER.getPH(), this._waterVolume))));
        this.notifyStateChanged();
    }

    private static final double pHCombined(double d, double d2, double d3, double d4) {
        if (d < 7.0 && d3 > 7.0 || d > 7.0 && d3 < 7.0) {
            throw new UnsupportedOperationException("combining acids and bases is not supported");
        }
        double d5 = 0.0;
        d5 = d < 7.0 ? -MathUtil.log10((Math.pow(10.0, -d) * d2 + Math.pow(10.0, -d3) * d4) / (d2 + d4)) : 14.0 + MathUtil.log10((Math.pow(10.0, d - 14.0) * d2 + Math.pow(10.0, d3 - 14.0) * d4) / (d2 + d4));
        return d5;
    }

    public void addLiquidListener(LiquidListener liquidListener) {
        this._listeners.add(liquidListener);
    }

    private void notifyStateChanged() {
        Iterator iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            ((LiquidListener)iterator.next()).stateChanged();
        }
    }

    public static interface LiquidListener {
        public void stateChanged();
    }
}

