/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.developer;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.controls.ColorControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.phscale.view.beaker.ParticlesNode;
import java.awt.Frame;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParticleControlsPanel
extends JPanel {
    private static final DoubleRange NUM_PARTICLES_PH7_RANGE = new DoubleRange(50.0, 200.0);
    private static final DoubleRange NUM_PARTICLES_PH15_RANGE = new DoubleRange(1000.0, 10000.0);
    private static final DoubleRange MIN_MINORITY_PARTICLES_RANGE = new DoubleRange(1.0, 25.0);
    private static final DoubleRange PARTICLE_DIAMETER_RANGE = new DoubleRange(1.0, 25.0);
    private static final DoubleRange TRANSPARENCY_RANGE = new DoubleRange(0.0, 255.0);
    private final ParticlesNode _particlesNode;
    private final LinearValueControl _numberOfParticlesAtPH7Control;
    private final LinearValueControl _numberOfParticlesAtPH15Control;
    private final LinearValueControl _minMinorityParticlesControl;
    private final LinearValueControl _diameterControl;
    private final LinearValueControl _majorityTransparencyControl;
    private final LinearValueControl _minorityTransparencyControl;
    private final ColorControl _h3oColorControl;
    private final ColorControl _ohColorControl;

    public ParticleControlsPanel(Frame frame, ParticlesNode particlesNode) {
        this._particlesNode = particlesNode;
        this._numberOfParticlesAtPH7Control = new LinearValueControl(NUM_PARTICLES_PH7_RANGE.getMin(), NUM_PARTICLES_PH7_RANGE.getMax(), "# particles at pH=7:", "##0", "");
        this._numberOfParticlesAtPH7Control.setValue(particlesNode.getNumberOfParticlesAtPH7());
        this._numberOfParticlesAtPH7Control.setUpDownArrowDelta(1.0);
        this._numberOfParticlesAtPH7Control.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleControlsPanel.this._particlesNode.setNumberOfParticlesAtPH7((int)ParticleControlsPanel.this._numberOfParticlesAtPH7Control.getValue());
            }
        });
        this._numberOfParticlesAtPH15Control = new LinearValueControl(NUM_PARTICLES_PH15_RANGE.getMin(), NUM_PARTICLES_PH15_RANGE.getMax(), "# particles at pH=15:", "####0", "");
        this._numberOfParticlesAtPH15Control.setValue(particlesNode.getNumberOfParticlesAtPH15());
        this._numberOfParticlesAtPH15Control.setUpDownArrowDelta(1.0);
        this._numberOfParticlesAtPH15Control.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleControlsPanel.this._particlesNode.setNumberOfParticlesAtPH15((int)ParticleControlsPanel.this._numberOfParticlesAtPH15Control.getValue());
            }
        });
        this._minMinorityParticlesControl = new LinearValueControl(MIN_MINORITY_PARTICLES_RANGE.getMin(), MIN_MINORITY_PARTICLES_RANGE.getMax(), "min # of minority particles:", "#0", "");
        this._minMinorityParticlesControl.setValue(particlesNode.getMinMinorityParticles());
        this._minMinorityParticlesControl.setUpDownArrowDelta(1.0);
        this._minMinorityParticlesControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleControlsPanel.this._particlesNode.setMinMinorityParticles((int)ParticleControlsPanel.this._minMinorityParticlesControl.getValue());
            }
        });
        this._diameterControl = new LinearValueControl(PARTICLE_DIAMETER_RANGE.getMin(), PARTICLE_DIAMETER_RANGE.getMax(), "particle diameter:", "#0.0", "");
        this._diameterControl.setValue(this._particlesNode.getParticleDiameter());
        this._diameterControl.setUpDownArrowDelta(0.1);
        this._diameterControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleControlsPanel.this._particlesNode.setParticleDiameter(ParticleControlsPanel.this._diameterControl.getValue());
            }
        });
        this._majorityTransparencyControl = new LinearValueControl(TRANSPARENCY_RANGE.getMin(), TRANSPARENCY_RANGE.getMax(), "majority transparency:", "##0", "");
        this._majorityTransparencyControl.setValue(this._particlesNode.getMajorityTransparency());
        this._majorityTransparencyControl.setUpDownArrowDelta(1.0);
        this._majorityTransparencyControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleControlsPanel.this._particlesNode.setMajorityTransparency((int)ParticleControlsPanel.this._majorityTransparencyControl.getValue());
            }
        });
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(this._majorityTransparencyControl.getMinimum()), new JLabel("invisible"));
        hashtable.put(new Double(this._majorityTransparencyControl.getMaximum()), new JLabel("opaque"));
        this._majorityTransparencyControl.setTickLabels(hashtable);
        this._minorityTransparencyControl = new LinearValueControl(TRANSPARENCY_RANGE.getMin(), TRANSPARENCY_RANGE.getMax(), "minority transparency:", "##0", "");
        this._minorityTransparencyControl.setValue(this._particlesNode.getMinorityTransparency());
        this._minorityTransparencyControl.setUpDownArrowDelta(1.0);
        this._minorityTransparencyControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleControlsPanel.this._particlesNode.setMinorityTransparency((int)ParticleControlsPanel.this._minorityTransparencyControl.getValue());
            }
        });
        Hashtable<Double, JLabel> hashtable2 = new Hashtable<Double, JLabel>();
        hashtable2.put(new Double(this._minorityTransparencyControl.getMinimum()), new JLabel("invisible"));
        hashtable2.put(new Double(this._minorityTransparencyControl.getMaximum()), new JLabel("opaque"));
        this._minorityTransparencyControl.setTickLabels(hashtable2);
        this._h3oColorControl = new ColorControl(frame, "H3O color:", this._particlesNode.getH3OColor());
        this._h3oColorControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleControlsPanel.this._particlesNode.setH3OColor(ParticleControlsPanel.this._h3oColorControl.getColor());
            }
        });
        this._ohColorControl = new ColorControl(frame, "OH color:", this._particlesNode.getOHColor());
        this._ohColorControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ParticleControlsPanel.this._particlesNode.setOHColor(ParticleControlsPanel.this._ohColorControl.getColor());
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(this._numberOfParticlesAtPH7Control, n++, n2);
        easyGridBagLayout.addComponent(this._numberOfParticlesAtPH15Control, n++, n2);
        easyGridBagLayout.addComponent(this._minMinorityParticlesControl, n++, n2);
        easyGridBagLayout.addComponent(this._diameterControl, n++, n2);
        easyGridBagLayout.addComponent(this._majorityTransparencyControl, n++, n2);
        easyGridBagLayout.addComponent(this._minorityTransparencyControl, n++, n2);
        easyGridBagLayout.addComponent(this._h3oColorControl, n++, n2);
        easyGridBagLayout.addComponent(this._ohColorControl, n++, n2);
    }
}

