/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.developer;

import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.phscale.PHScaleApplication;
import edu.colorado.phet.phscale.developer.ParticleControlsDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;

public class ParticleControlsMenuItem
extends JCheckBoxMenuItem {
    private final PHScaleApplication app;
    private JDialog dialog;

    public ParticleControlsMenuItem(PHScaleApplication pHScaleApplication) {
        super("Particle controls...");
        this.app = pHScaleApplication;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParticleControlsMenuItem.this.handleParticleControls();
            }
        });
    }

    private void handleParticleControls() {
        if (this.isSelected()) {
            PhetFrame phetFrame = this.app.getPhetFrame();
            this.dialog = new ParticleControlsDialog((Frame)phetFrame, this.app);
            this.dialog.setVisible(true);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    this.cleanup();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.cleanup();
                }

                private void cleanup() {
                    ParticleControlsMenuItem.this.setSelected(false);
                    ParticleControlsMenuItem.this.dialog = null;
                }
            });
        } else {
            this.dialog.dispose();
        }
    }
}

