/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.developer;

import edu.colorado.phet.common.phetcommon.view.controls.ColorControl;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.phscale.model.LiquidDescriptor;
import java.awt.Color;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LiquidColorsPanel
extends JPanel {
    public LiquidColorsPanel(Frame frame, LiquidDescriptor[] liquidDescriptorArray) {
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < liquidDescriptorArray.length; ++i) {
            LiquidColorControl liquidColorControl = new LiquidColorControl(frame, liquidDescriptorArray[i]);
            easyGridBagLayout.addAnchoredComponent(liquidColorControl, n++, n2, 13);
        }
    }

    private static class LiquidColorControl
    extends JPanel {
        private final ColorControl _colorControl;
        private final JSpinner _alphaSpinner;
        private final JLabel _rgbaLabel;

        public LiquidColorControl(Frame frame, final LiquidDescriptor liquidDescriptor) {
            String string = liquidDescriptor.getName() + " =  RGB:";
            Color color = liquidDescriptor.getColor();
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue());
            this._colorControl = new ColorControl(frame, string, color2);
            this._colorControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    Color color = ColorUtils.createColor(LiquidColorControl.this._colorControl.getColor(), liquidDescriptor.getColor().getAlpha());
                    liquidDescriptor.dev_setColor(color);
                    LiquidColorControl.this.setRGBALabel(color);
                }
            });
            this.add(this._colorControl);
            this.add(new JLabel("A:"));
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(color.getAlpha(), 0, 255, 1);
            this._alphaSpinner = new JSpinner(spinnerNumberModel);
            this._alphaSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = (Integer)LiquidColorControl.this._alphaSpinner.getValue();
                    Color color = ColorUtils.createColor(liquidDescriptor.getColor(), n);
                    liquidDescriptor.dev_setColor(color);
                    LiquidColorControl.this.setRGBALabel(color);
                }
            });
            this.add(this._alphaSpinner);
            this._rgbaLabel = new JLabel();
            this.setRGBALabel(color);
            this.add(this._rgbaLabel);
        }

        private void setRGBALabel(Color color) {
            String string = " = [" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha() + "]";
            this._rgbaLabel.setText(string);
        }
    }
}

