/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale.developer;

import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.phscale.PHScaleApplication;
import edu.colorado.phet.phscale.developer.LiquidColorsDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;

public class LiquidColorsMenuItem
extends JCheckBoxMenuItem {
    private final PHScaleApplication app;
    private JDialog dialog;

    public LiquidColorsMenuItem(PHScaleApplication pHScaleApplication) {
        super("Liquid colors...");
        this.app = pHScaleApplication;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LiquidColorsMenuItem.this.handleLiquidColors();
            }
        });
    }

    private void handleLiquidColors() {
        if (this.isSelected()) {
            PhetFrame phetFrame = this.app.getPhetFrame();
            this.dialog = new LiquidColorsDialog(phetFrame);
            this.dialog.setVisible(true);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    this.cleanup();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.cleanup();
                }

                private void cleanup() {
                    LiquidColorsMenuItem.this.setSelected(false);
                    LiquidColorsMenuItem.this.dialog = null;
                }
            });
        } else {
            this.dialog.dispose();
        }
    }
}

