/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.phscale;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.phscale.PHScaleConstants;
import edu.colorado.phet.phscale.PHScaleResetAllButton;
import edu.colorado.phet.phscale.model.Liquid;
import edu.colorado.phet.phscale.model.PHScaleModel;
import edu.colorado.phet.phscale.view.beaker.BeakerControlNode;
import edu.colorado.phet.phscale.view.beaker.ParticlesNode;
import edu.colorado.phet.phscale.view.graph.GraphControlNode;
import edu.colorado.phet.phscale.view.phslider.PHControlNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class PHScaleCanvas
extends PhetPCanvas {
    private static final Dimension RENDERING_SIZE = new Dimension(1080, 768);
    private final PNode _rootNode;
    private final BeakerControlNode _beakerControlNode;
    private final PHControlNode _pHControlNode;
    private final GraphControlNode _graphControlNode;
    private final PHScaleResetAllButton _resetAllButton;

    public PHScaleCanvas(PHScaleModel pHScaleModel, Resettable resettable) {
        this.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, RENDERING_SIZE));
        this.setBackground(PHScaleConstants.CANVAS_BACKGROUND);
        Liquid liquid = pHScaleModel.getLiquid();
        this._rootNode = new PNode();
        this.addWorldChild(this._rootNode);
        this._beakerControlNode = new BeakerControlNode(liquid, this);
        this._pHControlNode = new PHControlNode(liquid, 24.0);
        this._graphControlNode = new GraphControlNode(liquid, 24.0);
        this._resetAllButton = new PHScaleResetAllButton(resettable, (Component)this);
        PSwing pSwing = new PSwing(this._resetAllButton);
        this._rootNode.addChild(this._beakerControlNode);
        this._rootNode.addChild(this._pHControlNode);
        this._rootNode.addChild(this._graphControlNode);
        this._rootNode.addChild(pSwing);
        this._beakerControlNode.setOffset(25.0, 15.0);
        double d = this._beakerControlNode.getFullBoundsReference().getMaxX() + 15.0;
        double d2 = this._beakerControlNode.getFullBoundsReference().getY() + 56.0;
        this._pHControlNode.setOffset(d, d2);
        d = this._pHControlNode.getFullBoundsReference().getX() + (this._pHControlNode.getFullBoundsReference().getWidth() - pSwing.getFullBoundsReference().getWidth()) / 2.0;
        d2 = this._pHControlNode.getFullBoundsReference().getMaxY() + 70.0;
        pSwing.setOffset(d, d2);
        d = this._pHControlNode.getFullBoundsReference().getMaxX() + 120.0;
        d2 = 10.0;
        this._graphControlNode.setOffset(d, d2);
        Point2D point2D = this._rootNode.globalToLocal(this._pHControlNode.getTickAlignmentGlobalOffset());
        Point2D point2D2 = this._rootNode.globalToLocal(this._graphControlNode.getTickAlignmentGlobalOffset());
        this._pHControlNode.setOffset(this._pHControlNode.getXOffset(), this._pHControlNode.getYOffset() + (point2D2.getY() - point2D.getY()));
    }

    public BeakerControlNode getBeakerControlNode() {
        return this._beakerControlNode;
    }

    public GraphControlNode getGraphControlNode() {
        return this._graphControlNode;
    }

    public ParticlesNode dev_getParticlesNode() {
        return this._beakerControlNode.dev_getParticlesNode();
    }
}

