/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class RectangularBackgroundNode
extends PNode {
    private final PNode _foregroundNode;
    private final Insets _insets;
    private final Rectangle2D _rectangle;
    private final PPath _pathNode;

    public RectangularBackgroundNode(PNode pNode, Insets insets, Paint paint) {
        this(pNode, insets, paint, null, null);
    }

    public RectangularBackgroundNode(PNode pNode, Insets insets, Paint paint, Paint paint2, Stroke stroke) {
        this._foregroundNode = pNode;
        this._insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this._foregroundNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fullBounds")) {
                    RectangularBackgroundNode.this.update();
                }
            }
        });
        this._rectangle = new Rectangle2D.Double();
        this._pathNode = new PPath();
        this._pathNode.setPaint(paint);
        this._pathNode.setStrokePaint(paint2);
        this._pathNode.setStroke(stroke);
        this.addChild(this._pathNode);
        this.addChild(this._foregroundNode);
        this.update();
    }

    private void update() {
        PBounds pBounds = this._foregroundNode.getFullBoundsReference();
        double d = pBounds.getMinX() - (double)this._insets.left;
        double d2 = pBounds.getMinY() - (double)this._insets.top;
        double d3 = pBounds.getWidth() + (double)this._insets.left + (double)this._insets.right;
        double d4 = pBounds.getHeight() + (double)this._insets.top + (double)this._insets.bottom;
        this._rectangle.setRect(d, d2, d3, d4);
        this._pathNode.setPathTo(this._rectangle);
    }
}

