/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;

public class DefaultDecimalFormat
extends DecimalFormat {
    private NumberFormat decimalFormat;

    public DefaultDecimalFormat(String string) {
        this(DecimalFormat.getNumberInstance(PhetResources.readLocale()));
        if (string.contains("E")) {
            throw new IllegalArgumentException("scientific notation is not supported, see Unfuddle #3664: " + string);
        }
        if (this.decimalFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.decimalFormat).applyPattern(string);
        }
    }

    public DefaultDecimalFormat(NumberFormat numberFormat) {
        this.decimalFormat = numberFormat;
    }

    private double roundNearestNeighbor(double d) {
        int n = (int)Math.floor(Math.abs(d));
        int n2 = n == 0 ? 0 : Integer.toString(n).length();
        int n3 = this.decimalFormat.getMaximumFractionDigits() + n2;
        BigDecimal bigDecimal = new BigDecimal(d, new MathContext(n3, RoundingMode.HALF_UP));
        BigDecimal bigDecimal2 = bigDecimal.setScale(n3, RoundingMode.HALF_UP);
        return bigDecimal2.doubleValue();
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        double d2 = this.roundNearestNeighbor(d);
        StringBuffer stringBuffer2 = this.decimalFormat.format(d2, new StringBuffer(), fieldPosition);
        double d3 = 0.0;
        try {
            d3 = this.decimalFormat.parse(stringBuffer2.toString()).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            return this.decimalFormat.format(d, stringBuffer, fieldPosition);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        if (d3 == 0.0 && stringBuffer2.indexOf("-") == 0) {
            stringBuffer.append(stringBuffer2.substring(1));
        } else {
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer;
    }
}

