/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.BSON;
import org.bson.types.ObjectId;

public class Bytes
extends BSON {
    static final Logger LOGGER = Logger.getLogger("com.mongodb");
    static final boolean D = Boolean.getBoolean("DEBUG.MONGO");
    public static final ByteOrder ORDER;
    static final int CONNECTIONS_PER_HOST;
    static final ObjectId COLLECTION_REF_ID;

    static {
        if (LOGGER.getLevel() == null) {
            if (D) {
                LOGGER.setLevel(Level.ALL);
            } else {
                LOGGER.setLevel(Level.WARNING);
            }
        }
        ORDER = ByteOrder.LITTLE_ENDIAN;
        CONNECTIONS_PER_HOST = Integer.parseInt(System.getProperty("MONGO.POOLSIZE", "10"));
        COLLECTION_REF_ID = new ObjectId(-1, -1, -1);
    }

    static class OptionHolder {
        final OptionHolder _parent;
        int _options = 0;
        boolean _hasOptions = false;

        OptionHolder(OptionHolder parent) {
            this._parent = parent;
        }

        void set(int options) {
            this._options = options;
            this._hasOptions = true;
        }

        int get() {
            if (this._hasOptions) {
                return this._options;
            }
            if (this._parent == null) {
                return 0;
            }
            return this._parent.get();
        }

        void add(int option) {
            this.set(this.get() | option);
        }
    }
}

