/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.event.BoundedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.RulerNode;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;

public class OTRulerNode
extends RulerNode
implements Observer {
    private static final Dimension2D DEFAULT_WORLD_SIZE = new PDimension(600.0, 600.0);
    private int _majorTickInterval;
    private Laser _laser;
    private OTModelViewTransform _modelViewTransform;
    private PPath _dragBoundsNode;
    private Dimension2D _worldSize;

    public OTRulerNode(int n, int n2, Laser laser, OTModelViewTransform oTModelViewTransform, PPath pPath) {
        super(DEFAULT_WORLD_SIZE.getWidth(), 40.0, null, OTResources.getString("units.position"), n2, 12);
        this.setUnitsAssociatedMajorTickLabel("0");
        this.setBackgroundPaint(OTConstants.RULER_COLOR);
        this.setInsetWidth(100.0);
        this._majorTickInterval = n;
        this._laser = laser;
        this._laser.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._dragBoundsNode = pPath;
        this.addInputEventListener(new CursorHandler(OTConstants.UP_DOWN_CURSOR));
        this.addInputEventListener(new BoundedDragHandler(this, pPath));
        this._worldSize = new PDimension(DEFAULT_WORLD_SIZE);
        this.updateWidth();
        this.updatePosition();
    }

    public void setWorldSize(Dimension2D dimension2D) {
        this._worldSize.setSize(dimension2D);
        this.updateWidth();
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            if (bl) {
                this.updatePosition();
            }
            super.setVisible(bl);
        }
    }

    public void update(Observable observable, Object object) {
        if (this.isVisible() && observable == this._laser && object == "position") {
            this.updatePosition();
        }
    }

    private void updateWidth() {
        double d = this._modelViewTransform.viewToModel(this._worldSize.getWidth());
        double d2 = 3.0 * d;
        int n = (int)(d2 / (double)this._majorTickInterval);
        if (n % 2 == 0) {
            ++n;
        }
        double d3 = (double)(n - 1) * this._modelViewTransform.modelToView(this._majorTickInterval);
        this.setDistanceBetweenFirstAndLastTick(d3);
        String[] stringArray = new String[n];
        int n2 = -this._majorTickInterval * (n - 1) / 2;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.valueOf(n2);
            n2 += this._majorTickInterval;
        }
        this.setMajorTickLabels(stringArray);
        this.updatePosition();
    }

    private void updatePosition() {
        double d = this._laser.getPositionReference().getX();
        double d2 = this._modelViewTransform.modelToView(d) - this.getFullBoundsReference().getWidth() / 2.0;
        double d3 = this.getOffset().getY();
        this.setOffset(d2, d3);
        PBounds pBounds = this.getFullBoundsReference();
        Rectangle2D.Double double_ = new Rectangle2D.Double(pBounds.getX(), 0.0, pBounds.getWidth(), this._worldSize.getHeight());
        this._dragBoundsNode.setPathTo(double_);
    }
}

