/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.BoundedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.DragNotificationHandler;
import edu.colorado.phet.common.piccolophet.nodes.FineCrosshairNode;
import edu.colorado.phet.common.piccolophet.nodes.HandleNode;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.control.LaserControlPanel;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.view.ElectricFieldNode;
import edu.colorado.phet.opticaltweezers.view.LaserBeamNode;
import edu.colorado.phet.opticaltweezers.view.LaserOutlineNode;
import edu.colorado.phet.opticaltweezers.view.ObjectiveNode;
import edu.colorado.phet.opticaltweezers.view.ObjectiveSupportNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;

public class LaserNode
extends PhetPNode
implements PropertyChangeListener,
Observer {
    private static final Color HANDLE_COLOR = Color.LIGHT_GRAY;
    private static final Color CROSSHAIR_COLOR = new Color(0, 0, 0, 80);
    private static final Stroke CROSSHAIR_STROKE = new BasicStroke(1.0f);
    private Laser _laser;
    private OTModelViewTransform _modelViewTransform;
    private Point2D _pModel;
    private LaserOutlineNode _outlineNode;
    private LaserBeamNode _beamNode;
    private ElectricFieldNode _electricFieldNode;
    private LaserControlPanel _controlPanel;
    private PNode _centerCrosshair;
    private PPath _originMarkerNode;
    private HandleNode _leftHandleNode;
    private HandleNode _rightHandleNode;
    private DragNotificationHandler _dragNotificationHandler;
    private boolean _beamVisible;
    private boolean _electricFieldVisible;

    public LaserNode(Laser laser, OTModelViewTransform oTModelViewTransform, PNode pNode) {
        this._laser = laser;
        this._laser.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._pModel = new Point2D.Double();
        double d = this._modelViewTransform.modelToView(this._laser.getDiameterAtObjective());
        double d2 = this._modelViewTransform.modelToView(this._laser.getDistanceFromObjectiveToWaist());
        double d3 = this._modelViewTransform.modelToView(this._laser.getDistanceFromObjectiveToControlPanel());
        double d4 = d / 0.95;
        double d5 = d4 / 12.0;
        ObjectiveNode objectiveNode = new ObjectiveNode(d4, d5);
        this._controlPanel = new LaserControlPanel(laser, OTConstants.PLAY_AREA_CONTROL_FONT, d4);
        double d6 = this._controlPanel.getFullBoundsReference().getHeight();
        double d7 = d3 + d6;
        ObjectiveSupportNode objectiveSupportNode = new ObjectiveSupportNode(d7);
        ObjectiveSupportNode objectiveSupportNode2 = new ObjectiveSupportNode(d7);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(-1.0, 1.0);
        objectiveSupportNode2.setTransform(affineTransform);
        this._outlineNode = new LaserOutlineNode(this._laser, this._modelViewTransform);
        this._beamNode = new LaserBeamNode(this._laser, this._modelViewTransform);
        this._beamVisible = true;
        this._electricFieldNode = new ElectricFieldNode(this._laser, this._modelViewTransform);
        this._electricFieldVisible = true;
        this._centerCrosshair = new FineCrosshairNode(15.0, CROSSHAIR_STROKE, (Paint)CROSSHAIR_COLOR);
        this._originMarkerNode = new PPath();
        Line2D.Double double_ = new Line2D.Double(0.0, -d2, 0.0, d2 + d3);
        this._originMarkerNode.setPathTo(double_);
        this._originMarkerNode.setPaint(null);
        this._originMarkerNode.setStrokePaint(OTConstants.ORIGIN_MARKER_COLOR);
        this._originMarkerNode.setStroke(OTConstants.ORIGIN_MARKER_STROKE);
        this._originMarkerNode.setVisible(false);
        double d8 = 0.8 * d6;
        this._leftHandleNode = new HandleNode(25.0, d8, HANDLE_COLOR);
        this._rightHandleNode = new HandleNode(25.0, d8, HANDLE_COLOR);
        this.addChild(objectiveNode);
        this.addChild(objectiveSupportNode);
        this.addChild(objectiveSupportNode2);
        this.addChild(this._beamNode);
        this.addChild(this._electricFieldNode);
        this.addChild(this._outlineNode);
        this.addChild(this._originMarkerNode);
        this.addChild(this._leftHandleNode);
        this.addChild(this._rightHandleNode);
        this.addChild(this._controlPanel);
        this.addChild(this._centerCrosshair);
        double d9 = -this._beamNode.getFullBoundsReference().getWidth() / 2.0;
        double d10 = -d2;
        this._beamNode.setOffset(d9, d10);
        this._electricFieldNode.setOffset(d9, d10);
        this._outlineNode.setOffset(d9, d10);
        objectiveNode.setOffset(0.0, d2);
        PBounds pBounds = objectiveNode.getFullBoundsReference();
        this._controlPanel.setOffset(-this._controlPanel.getFullBoundsReference().getWidth() / 2.0, d2 + d3);
        PBounds pBounds2 = this._controlPanel.getFullBoundsReference();
        objectiveSupportNode.setOffset(pBounds.getX(), d2 - objectiveSupportNode.getHeadHeight() / 2.0);
        objectiveSupportNode2.setOffset(pBounds.getMaxX(), d2 - objectiveSupportNode2.getHeadHeight() / 2.0);
        PBounds pBounds3 = this._leftHandleNode.getFullBoundsReference();
        this._leftHandleNode.setOffset(pBounds2.getX() - pBounds3.getWidth() + 2.0, pBounds2.getY() + (pBounds2.getHeight() - pBounds3.getHeight()) / 2.0);
        PBounds pBounds4 = this._rightHandleNode.getFullBoundsReference();
        this._rightHandleNode.rotate(Math.toRadians(180.0));
        this._rightHandleNode.setOffset(pBounds2.getMaxX() + pBounds4.getWidth() - 2.0, pBounds2.getMaxY() - (pBounds2.getHeight() - pBounds4.getHeight()) / 2.0);
        Cursor cursor = OTConstants.LEFT_RIGHT_CURSOR;
        objectiveNode.addInputEventListener(new CursorHandler(cursor));
        this._leftHandleNode.addInputEventListener(new CursorHandler(cursor));
        this._rightHandleNode.addInputEventListener(new CursorHandler(cursor));
        objectiveSupportNode.addInputEventListener(new CursorHandler(cursor));
        objectiveSupportNode2.addInputEventListener(new CursorHandler(cursor));
        this._controlPanel.initDragCursor(cursor);
        BoundedDragHandler boundedDragHandler = new BoundedDragHandler(this, pNode);
        objectiveNode.addInputEventListener(boundedDragHandler);
        this._leftHandleNode.addInputEventListener(boundedDragHandler);
        this._rightHandleNode.addInputEventListener(boundedDragHandler);
        objectiveSupportNode.addInputEventListener(boundedDragHandler);
        objectiveSupportNode2.addInputEventListener(boundedDragHandler);
        this._controlPanel.initDragHandler(this, pNode);
        this._dragNotificationHandler = new DragNotificationHandler(this);
        objectiveNode.addInputEventListener(this._dragNotificationHandler);
        this._leftHandleNode.addInputEventListener(this._dragNotificationHandler);
        this._rightHandleNode.addInputEventListener(this._dragNotificationHandler);
        objectiveSupportNode.addInputEventListener(this._dragNotificationHandler);
        objectiveSupportNode2.addInputEventListener(this._dragNotificationHandler);
        this._controlPanel.addInputEventListener(this._dragNotificationHandler);
        this.addPropertyChangeListener(this);
        this.updatePosition();
    }

    public void setBeamVisible(boolean bl) {
        this._beamVisible = bl;
        this._beamNode.setVisible(bl);
        this.updateVisibility();
    }

    public void setElectricFieldVisible(boolean bl) {
        this._electricFieldVisible = bl;
        this._electricFieldNode.setVisible(bl);
        this.updateVisibility();
    }

    public void setOriginMarkerVisible(boolean bl) {
        this._originMarkerNode.setVisible(bl);
    }

    public ElectricFieldNode getElectricFieldNode() {
        return this._electricFieldNode;
    }

    public PNode getLeftHandleNode() {
        return this._leftHandleNode;
    }

    public void addDragNotificationListener(DragNotificationHandler.DragNotificationListener dragNotificationListener) {
        this._dragNotificationHandler.addDragNotificationListener(dragNotificationListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("transform")) {
            double d = this.getOffset().getX();
            double d2 = this._modelViewTransform.viewToModel(d);
            double d3 = this._laser.getPositionReference().getY();
            this._laser.deleteObserver(this);
            this._laser.setPosition(d2, d3);
            this._laser.addObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._laser) {
            if (object == "position") {
                this.updatePosition();
            } else if (object == "running") {
                this.updateVisibility();
            } else if (object == null) {
                throw new IllegalArgumentException("LaserNode.update, arg=null");
            }
        }
    }

    private void updatePosition() {
        this._modelViewTransform.modelToView(this._laser.getPosition(), this._pModel);
        this.removePropertyChangeListener(this);
        this.setOffset(this._pModel);
        this.addPropertyChangeListener(this);
    }

    private void updateVisibility() {
        boolean bl = this._laser.isRunning();
        this._beamNode.setVisible(bl && this._beamVisible);
        this._electricFieldNode.setVisible(bl && this._electricFieldVisible);
        this._outlineNode.setVisible(bl);
        this._centerCrosshair.setVisible(bl);
    }
}

