/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ScaleAlphaImageOpARGB;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.Observable;
import java.util.Observer;

public class LaserBeamNode
extends PhetPNode
implements Observer {
    private Laser _laser;
    private OTModelViewTransform _modelViewTransform;
    private PImage _gradientNode;
    private ScaleAlphaImageOpARGB _imageOp;
    private BufferedImage _maxPowerGradientImage;
    private BufferedImage _actualPowerGradientImage;

    public LaserBeamNode(Laser laser, OTModelViewTransform oTModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._laser = laser;
        this._laser.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._imageOp = new ScaleAlphaImageOpARGB();
        this._maxPowerGradientImage = this.createMaxPowerGradientImage();
        this._actualPowerGradientImage = this._imageOp.createCompatibleDestImage(this._maxPowerGradientImage, this._maxPowerGradientImage.getColorModel());
        this._gradientNode = new PImage(this._actualPowerGradientImage);
        this._gradientNode.setOffset(0.0, -this._modelViewTransform.modelToView(this._laser.getDistanceFromObjectiveToControlPanel()));
        this.addChild(this._gradientNode);
        this.updateAlpha();
    }

    public void update(Observable observable, Object object) {
        if (observable == this._laser && object == "power") {
            this.updateAlpha();
        }
    }

    private void updateAlpha() {
        double d = Math.sqrt(this._laser.getPower() / this._laser.getPowerRange().getMax());
        this._imageOp.setScale(d);
        this._imageOp.filter(this._maxPowerGradientImage, this._actualPowerGradientImage);
        this._gradientNode.setImage(this._actualPowerGradientImage);
    }

    private BufferedImage createMaxPowerGradientImage() {
        int n;
        int n2;
        int n3 = (int)(this._laser.getDiameterAtObjective() / 2.0);
        int n4 = (int)this._laser.getDistanceFromObjectiveToControlPanel();
        int n5 = (int)this._laser.getDistanceFromObjectiveToWaist();
        int n6 = n4 + n5;
        BufferedImage bufferedImage = new BufferedImage(n3, n6, 2);
        Color color = VisibleColor.wavelengthToColor(this._laser.getVisibleWavelength());
        int n7 = color.getRed();
        int n8 = color.getGreen();
        int n9 = color.getBlue();
        double d = this._laser.getPowerRange().getMax();
        double d2 = this._laser.getMaxIntensity();
        int[][] nArray = new int[n3][n6];
        for (int i = 0; i < n6; ++i) {
            double d3 = 0.0;
            d3 = i < n5 ? this._laser.getRadius(i) : this._laser.getRadius(this._laser.getDistanceFromObjectiveToWaist());
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                if ((double)n2 <= d3) {
                    double d4 = Laser.getIntensityOnRadius(n2, d3, d);
                    int n10 = (int)(255.0 * d4 / d2);
                    n = n10 << 24 | n7 << 16 | n8 << 8 | n9;
                }
                nArray[n2][i] = n;
            }
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray2 = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n11 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            for (n = 0; n < n3; ++n) {
                nArray2[n11] = nArray[n][n2];
                ++n11;
            }
        }
        double d5 = this._modelViewTransform.getScaleModelToView();
        BufferedImage bufferedImage2 = BufferedImageUtils.rescaleFractional(bufferedImage, d5, d5);
        BufferedImage bufferedImage3 = null;
        BufferedImage bufferedImage4 = bufferedImage2;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
        affineTransform.translate(-bufferedImage4.getWidth(null), 0.0);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        BufferedImage bufferedImage5 = affineTransformOp.filter(bufferedImage4, null);
        affineTransform = AffineTransform.getScaleInstance(-1.0, -1.0);
        affineTransform.translate(-bufferedImage4.getWidth(null), -bufferedImage4.getHeight(null));
        affineTransformOp = new AffineTransformOp(affineTransform, 1);
        BufferedImage bufferedImage6 = affineTransformOp.filter(bufferedImage4, null);
        affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        affineTransform.translate(0.0, -bufferedImage4.getHeight(null));
        affineTransformOp = new AffineTransformOp(affineTransform, 1);
        BufferedImage bufferedImage7 = affineTransformOp.filter(bufferedImage4, null);
        Graphics2D graphics2D = (Graphics2D)bufferedImage4.getGraphics();
        int n12 = 2 * bufferedImage4.getWidth();
        int n13 = 2 * bufferedImage4.getHeight();
        bufferedImage3 = graphics2D.getDeviceConfiguration().createCompatibleImage(n12, n13);
        graphics2D = (Graphics2D)bufferedImage3.getGraphics();
        graphics2D.drawImage(bufferedImage6, null, 0, 0);
        graphics2D.drawImage(bufferedImage7, null, n12 / 2, 0);
        graphics2D.drawImage(bufferedImage5, null, 0, n13 / 2);
        graphics2D.drawImage(bufferedImage4, null, n12 / 2, n13 / 2);
        return bufferedImage3;
    }
}

