/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.OTResources;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.util.OTVector2D;
import edu.colorado.phet.opticaltweezers.view.AbstractForceNode;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;

public class FluidDragForceNode
extends AbstractForceNode
implements Observer {
    private Fluid _fluid;
    private Bead _bead;
    private OTModelViewTransform _modelViewTransform;
    private Point2D _pModel;

    public FluidDragForceNode(Fluid fluid, Bead bead, OTModelViewTransform oTModelViewTransform, double d, double d2) {
        super(d, d2, OTResources.getString("units.force"), OTConstants.FLUID_DRAG_FORCE_COLOR);
        this._fluid = fluid;
        this._fluid.addObserver(this);
        this._bead = bead;
        this._bead.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._pModel = new Point2D.Double();
        this.updatePosition();
        this.updateVectors();
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            if (bl) {
                this.updatePosition();
                this.updateVectors();
            }
            super.setVisible(bl);
        }
    }

    public void update(Observable observable, Object object) {
        if (this.isVisible()) {
            if (observable == this._fluid) {
                this.updateVectors();
            } else if (observable == this._bead) {
                this.updatePosition();
                this.updateVectors();
            }
        }
    }

    private void updatePosition() {
        this._modelViewTransform.modelToView(this._bead.getPositionReference(), this._pModel);
        this.setOffset(this._pModel);
    }

    private void updateVectors() {
        OTVector2D oTVector2D = this._bead.getDragForce();
        this.setForce(oTVector2D);
    }

    public static Icon createIcon() {
        return AbstractForceNode.createIcon(OTConstants.FLUID_DRAG_FORCE_COLOR);
    }
}

