/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.view.ElectricFieldVectorNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class ElectricFieldNode
extends PhetPNode
implements Observer {
    private final Laser _laser;
    private final OTModelViewTransform _modelViewTransform;
    private final PNode _vectorNodesParent;
    private final List _vectorNodes;
    private Color _vectorColor;
    private boolean _valuesVisible;

    public ElectricFieldNode(Laser laser, OTModelViewTransform oTModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._laser = laser;
        this._laser.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._vectorNodesParent = new PComposite();
        this.addChild(this._vectorNodesParent);
        this._vectorNodes = new ArrayList();
        this._vectorColor = OTConstants.ELECTRIC_FIELD_COLOR;
        this._valuesVisible = false;
        this.initVectors();
    }

    private void initVectors() {
        this.removeAllElectricFieldVectorNodes();
        double d = this._laser.getRadius(0.0) - 30.0;
        double d2 = this._laser.getDistanceFromObjectiveToWaist() - 30.0;
        double d3 = d / 2.0;
        double d4 = d2 / 5.0;
        double d5 = this._laser.getMaxElectricFieldX();
        double d6 = this._modelViewTransform.modelToView(d3 - 10.0);
        double d7 = 0.0;
        for (double d8 = 0.0; d8 <= d2; d8 += d4) {
            d = this._laser.getRadius(d8) - 30.0;
            for (d7 = 0.0; d7 <= d; d7 += d3) {
                if (d7 == 0.0 && d8 == 0.0) {
                    this.addElectricFieldVectorNode(d7, d8, d5, d6);
                    continue;
                }
                if (d7 == 0.0) {
                    this.addElectricFieldVectorNode(d7, d8, d5, d6);
                    this.addElectricFieldVectorNode(d7, -d8, d5, d6);
                    continue;
                }
                this.addElectricFieldVectorNode(d7, d8, d5, d6);
                this.addElectricFieldVectorNode(d7, -d8, d5, d6);
                this.addElectricFieldVectorNode(-d7, d8, d5, d6);
                this.addElectricFieldVectorNode(-d7, -d8, d5, d6);
            }
        }
        this.updateVectors();
    }

    private void addElectricFieldVectorNode(double d, double d2, double d3, double d4) {
        ElectricFieldVectorNode electricFieldVectorNode = new ElectricFieldVectorNode(-d, d2, d3, d4);
        this._vectorNodes.add(electricFieldVectorNode);
        this._vectorNodesParent.addChild(electricFieldVectorNode);
        double d5 = this._modelViewTransform.modelToView(electricFieldVectorNode.getXOffset() + this._laser.getDiameterAtObjective() / 2.0 + d);
        double d6 = this._modelViewTransform.modelToView(electricFieldVectorNode.getYOffset() + this._laser.getY() + d2);
        electricFieldVectorNode.setOffset(d5, d6);
        if (d == 0.0 && d2 == 0.0) {
            electricFieldVectorNode.setValueVisible(this._valuesVisible);
        }
    }

    private void removeAllElectricFieldVectorNodes() {
        this._vectorNodes.clear();
        this._vectorNodesParent.removeAllChildren();
    }

    public void setVectorColor(Color color) {
        this._vectorColor = color;
        this.updateVectors();
    }

    public Color getVectorColor() {
        return this._vectorColor;
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            if (bl) {
                this.initVectors();
            }
            super.setVisible(bl);
        }
    }

    public void update(Observable observable, Object object) {
        if (this.isVisible() && observable == this._laser) {
            if (object == "electricField" || object == "power" || object == "running") {
                this.updateVectors();
            } else if (object == "electricFieldScale") {
                this.initVectors();
            }
        }
    }

    private void updateVectors() {
        double d = this._laser.getMaxElectricFieldX();
        for (ElectricFieldVectorNode electricFieldVectorNode : this._vectorNodes) {
            Point2D point2D = electricFieldVectorNode.getOffsetFromLaserReference();
            double d2 = this._laser.getElectricFieldX(point2D);
            electricFieldVectorNode.setXY(d2, 0.0);
            Color color = this._vectorColor;
            electricFieldVectorNode.setArrowStrokePaint(color);
        }
    }
}

