/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.opticaltweezers.model.DNAPivot;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.view.DNAExtensionNode;
import edu.colorado.phet.opticaltweezers.view.DNAPivotNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class DNAStrandNode
extends PNode
implements Observer {
    private static final Color STRAND_STROKE_COLOR = Color.BLACK;
    private static final Stroke STRAND_STROKE = new BasicStroke(1.0f);
    private DNAStrand _dnaStrand;
    private OTModelViewTransform _modelViewTransform;
    private GeneralPath _strandPath;
    private PPath _strandNode;
    private DNAExtensionNode _extensionNode;
    private PNode _pivotsParentNode;

    public DNAStrandNode(DNAStrand dNAStrand, OTModelViewTransform oTModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._dnaStrand = dNAStrand;
        this._dnaStrand.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._strandPath = new GeneralPath();
        this._strandNode = new PPath();
        this._strandNode.setStroke(STRAND_STROKE);
        this._strandNode.setStrokePaint(STRAND_STROKE_COLOR);
        this.addChild(this._strandNode);
        this._extensionNode = new DNAExtensionNode();
        this.addChild(this._extensionNode);
        this._pivotsParentNode = new PhetPNode();
        this.addChild(this._pivotsParentNode);
        this.update();
    }

    public void setPivotsVisible(boolean bl) {
        if (bl != this._pivotsParentNode.getVisible()) {
            this._pivotsParentNode.setVisible(bl);
            this.update();
            this.firePropertyChange(-1, "pivotsVisible", null, null);
        }
    }

    public boolean isPivotsVisible() {
        return this._pivotsParentNode.getVisible();
    }

    public void setExtensionVisible(boolean bl) {
        if (bl != this._extensionNode.getVisible()) {
            this._extensionNode.setVisible(bl);
            this.update();
            this.firePropertyChange(-1, "extensionVisible", null, null);
        }
    }

    public boolean isExtensionVisible() {
        return this._extensionNode.getVisible();
    }

    public void setStrandColor(Color color) {
        this._strandNode.setStrokePaint(color);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._dnaStrand && object == "shape") {
            this.update();
        }
    }

    private void update() {
        double d = this._modelViewTransform.modelToView(this._dnaStrand.getPinX());
        double d2 = this._modelViewTransform.modelToView(this._dnaStrand.getPinY());
        if (this.isExtensionVisible()) {
            double d3 = this._dnaStrand.getExtension();
            double d4 = this._modelViewTransform.modelToView(this._dnaStrand.getBeadX());
            double d5 = this._modelViewTransform.modelToView(this._dnaStrand.getBeadY());
            this._extensionNode.update(d3, d, d2, d4, d5);
        }
        this._strandPath.reset();
        this._pivotsParentNode.removeAllChildren();
        ArrayList arrayList = this._dnaStrand.getPivots();
        int n = arrayList.size();
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                DNAPivot dNAPivot = (DNAPivot)arrayList.get(i);
                double d6 = this._modelViewTransform.modelToView(dNAPivot.getX());
                double d7 = this._modelViewTransform.modelToView(dNAPivot.getY());
                if (i == 0) {
                    this._strandPath.moveTo((float)d6, (float)d7);
                } else {
                    this._strandPath.lineTo((float)d6, (float)d7);
                }
                if (!this.isPivotsVisible()) continue;
                DNAPivotNode dNAPivotNode = new DNAPivotNode(d6, d7);
                this._pivotsParentNode.addChild(dNAPivotNode);
            }
        }
        this._strandNode.setPathTo(this._strandPath);
    }
}

