/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.view.AbstractChargeNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;

public class ChargeDistributionNode
extends AbstractChargeNode {
    private DoubleRange _chargeMotionScaleRange;
    private double _chargeMotionScale;
    private ArrayList _positiveNodeList;
    private ArrayList _negativeNodeList;

    public ChargeDistributionNode(Bead bead, Laser laser, OTModelViewTransform oTModelViewTransform, DoubleRange doubleRange) {
        super(bead, laser, oTModelViewTransform);
        this._chargeMotionScaleRange = doubleRange;
        this._chargeMotionScale = this._chargeMotionScaleRange.getDefault();
    }

    protected void initialize() {
        Bead bead = this.getBead();
        OTModelViewTransform oTModelViewTransform = this.getModelViewTransform();
        double d = oTModelViewTransform.modelToView(bead.getDiameter());
        double d2 = oTModelViewTransform.modelToView(20.0);
        double d3 = oTModelViewTransform.modelToView(5.0);
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d);
        PClip pClip = new PClip();
        this.addChild(pClip);
        pClip.setPathTo(double_);
        pClip.setStroke(null);
        this._positiveNodeList = new ArrayList();
        this._negativeNodeList = new ArrayList();
        for (int i = 0; i < 25; ++i) {
            PNode pNode = ChargeDistributionNode.createPositiveNode(d2, d3);
            this._positiveNodeList.add(pNode);
            pClip.addChild(pNode);
            PNode pNode2 = ChargeDistributionNode.createNegativeNode(d2, d3);
            this._negativeNodeList.add(pNode2);
            pClip.addChild(pNode2);
        }
        this.layoutPositiveCharges();
        this.updateCharges();
    }

    protected void updateCharges() {
        this.layoutNegativeCharges();
    }

    public void setChargeMotionScale(double d) {
        if (!this._chargeMotionScaleRange.contains(d)) {
            throw new IllegalArgumentException("motionScale out of range: " + d);
        }
        if (d != this._chargeMotionScale) {
            this._chargeMotionScale = d;
        }
    }

    public double getChargeMotionScale() {
        return this._chargeMotionScale;
    }

    public DoubleRange getChargeMotionScaleRange() {
        return this._chargeMotionScaleRange;
    }

    private void layoutPositiveCharges() {
        double d;
        Bead bead = this.getBead();
        OTModelViewTransform oTModelViewTransform = this.getModelViewTransform();
        double d2 = oTModelViewTransform.modelToView(bead.getDiameter());
        double d3 = oTModelViewTransform.modelToView(5.0);
        double d4 = oTModelViewTransform.modelToView(20.0);
        double d5 = d = (d2 - d4 - 2.0 * d3) / 4.0;
        int n = 0;
        int n2 = 0;
        while ((double)n2 < 5.0) {
            double d6 = -(d2 / 2.0) + d3 + (double)n2 * d5;
            int n3 = 0;
            while ((double)n3 < 5.0) {
                PNode pNode = (PNode)this._positiveNodeList.get(n);
                double d7 = -(d2 / 2.0) + d3 + (double)n3 * d;
                pNode.setOffset(d7, d6);
                ++n;
                ++n3;
            }
            ++n2;
        }
    }

    private void layoutNegativeCharges() {
        double d;
        Bead bead = this.getBead();
        OTModelViewTransform oTModelViewTransform = this.getModelViewTransform();
        double d2 = bead.getElectricFieldX();
        double d3 = this.getChargeScale(d2) * this._chargeMotionScale;
        double d4 = oTModelViewTransform.modelToView(bead.getDiameter());
        double d5 = oTModelViewTransform.modelToView(5.0);
        double d6 = oTModelViewTransform.modelToView(20.0);
        double d7 = d = (d4 - d6 - 2.0 * d5) / 4.0;
        int n = 0;
        int n2 = 0;
        while ((double)n2 < 5.0) {
            double d8 = -(d4 / 2.0) + d5 + (double)n2 * d7;
            int n3 = 0;
            while ((double)n3 < 5.0) {
                PNode pNode = (PNode)this._negativeNodeList.get(n);
                double d9 = -(d4 / 2.0) + d5 + (double)n3 * (1.0 - d3) * d;
                if (d2 > 0.0) {
                    pNode.setOffset(d9, d8);
                } else {
                    pNode.setOffset(-d9 - d6, d8);
                }
                ++n;
                ++n3;
            }
            ++n2;
        }
    }
}

