/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.DragNotificationHandler;
import edu.colorado.phet.common.piccolophet.nodes.FineCrosshairNode;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.view.BeadDragHandler;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;

public class BeadNode
extends SphericalNode
implements PropertyChangeListener,
Observer {
    private static final Color PRIMARY_COLOR = new Color(200, 200, 0, 200);
    private static final Color HILITE_COLOR = new Color(255, 255, 0, 200);
    private static final Stroke STROKE = null;
    private static final Paint STROKE_PAINT = Color.BLACK;
    private static final Stroke CROSSHAIR_STROKE = new BasicStroke(1.0f);
    private static final Color CROSSHAIR_COLOR = new Color(0, 0, 0, 80);
    private Bead _bead;
    private OTModelViewTransform _modelViewTransform;
    private Point2D _pModel;
    private DragNotificationHandler _dragNotificationHandler;

    public BeadNode(double d) {
        super(true);
        this.setDiameter(d);
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint(0.0, d / 6.0, HILITE_COLOR, new Point2D.Double(d / 4.0, d / 4.0), PRIMARY_COLOR);
        this.setPaint(roundGradientPaint);
        this.setStroke(STROKE);
        this.setStrokePaint(STROKE_PAINT);
    }

    public BeadNode(Bead bead, OTModelViewTransform oTModelViewTransform, PNode pNode) {
        super(true);
        this.setStroke(STROKE);
        this.setStrokePaint(STROKE_PAINT);
        this.addChild(new FineCrosshairNode(15.0, CROSSHAIR_STROKE, (Paint)CROSSHAIR_COLOR));
        this._bead = bead;
        this._bead.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._pModel = new Point2D.Double();
        double d = this._modelViewTransform.modelToView(this._bead.getDiameter());
        this.setDiameter(d);
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint(0.0, d / 6.0, HILITE_COLOR, new Point2D.Double(d / 4.0, d / 4.0), PRIMARY_COLOR);
        this.setPaint(roundGradientPaint);
        CursorHandler cursorHandler = new CursorHandler();
        this.addInputEventListener(cursorHandler);
        BeadDragHandler beadDragHandler = new BeadDragHandler(this, pNode, cursorHandler);
        this.addInputEventListener(beadDragHandler);
        this._dragNotificationHandler = new DragNotificationHandler(this);
        this.addInputEventListener(this._dragNotificationHandler);
        this.addPropertyChangeListener(this);
        this.updatePosition();
    }

    public Bead getBead() {
        return this._bead;
    }

    public void addDragNotificationListener(DragNotificationHandler.DragNotificationListener dragNotificationListener) {
        this._dragNotificationHandler.addDragNotificationListener(dragNotificationListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this._bead != null && propertyChangeEvent.getPropertyName().equals("transform")) {
            Point2D point2D = this.getOffset();
            this._modelViewTransform.viewToModel(point2D, this._pModel);
            this._bead.deleteObserver(this);
            this._bead.setPosition(this._pModel);
            this._bead.addObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._bead && object == "position") {
            this.updatePosition();
        }
    }

    private void updatePosition() {
        this._modelViewTransform.modelToView(this._bead.getPositionReference(), this._pModel);
        this.removePropertyChangeListener(this);
        this.setOffset(this._pModel);
        this.addPropertyChangeListener(this);
    }
}

