/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.event.BoundedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.view.BeadNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;

class BeadDragHandler
extends BoundedDragHandler {
    private Bead _bead;
    private CursorHandler _cursorHandler;
    private boolean _ignoreDrag;

    public BeadDragHandler(BeadNode beadNode, PNode pNode, CursorHandler cursorHandler) {
        super(beadNode, pNode);
        this._bead = beadNode.getBead();
        this._cursorHandler = cursorHandler;
        this._ignoreDrag = false;
    }

    public void mousePressed(PInputEvent pInputEvent) {
        super.mousePressed(pInputEvent);
        this._bead.setMotionEnabled(false);
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        DNAStrand dNAStrand = this._bead.getDNAStrand();
        if (dNAStrand == null) {
            super.mouseDragged(pInputEvent);
        } else if (!this._ignoreDrag) {
            double d = this._bead.getX();
            double d2 = this._bead.getY();
            super.mouseDragged(pInputEvent);
            if (dNAStrand.getExtension() > dNAStrand.getMaxExtension()) {
                this._bead.setPosition(d, d2);
                this.endDrag(pInputEvent);
            }
        }
    }

    private void endDrag(PInputEvent pInputEvent) {
        super.mouseReleased(pInputEvent);
        this._ignoreDrag = true;
        this._bead.setMotionEnabled(true);
        this._cursorHandler.mouseReleased(pInputEvent);
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        super.mouseReleased(pInputEvent);
        this._ignoreDrag = false;
        this._bead.setMotionEnabled(true);
    }
}

