/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.opticaltweezers.model.AbstractEnzyme;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractEnzymeNode
extends PhetPNode
implements Observer {
    private static final Stroke TICK_STROKE = new BasicStroke(3.0f);
    private AbstractEnzyme _enzyme;
    private OTModelViewTransform _modelViewTransform;
    private PNode _innerNode;

    public AbstractEnzymeNode(AbstractEnzyme abstractEnzyme, OTModelViewTransform oTModelViewTransform, Paint paint, Paint paint2, Color color) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._enzyme = abstractEnzyme;
        this._enzyme.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        double d = this._modelViewTransform.modelToView(this._enzyme.getOuterDiameter());
        SphericalNode sphericalNode = new SphericalNode(d, paint, false);
        sphericalNode.setStroke(null);
        double d2 = this._modelViewTransform.modelToView(this._enzyme.getInnerDiameter());
        SphericalNode sphericalNode2 = new SphericalNode(d2, paint2, false);
        sphericalNode2.setStroke(null);
        Line2D.Double double_ = new Line2D.Double(0.0, 0.0, 0.0, sphericalNode2.getFullBoundsReference().getHeight() / 3.0);
        PPath pPath = new PPath(double_);
        pPath.setStroke(TICK_STROKE);
        pPath.setStrokePaint(color);
        this._innerNode = new PComposite();
        this._innerNode.addChild(sphericalNode2);
        this._innerNode.addChild(pPath);
        this.addChild(this._innerNode);
        this.addChild(sphericalNode);
        this.updatePosition();
        this.updateVisibility();
    }

    public AbstractEnzyme getEnzyme() {
        return this._enzyme;
    }

    private void updatePosition() {
        Point2D point2D = this._modelViewTransform.modelToView(this._enzyme.getPositionReference());
        this.setOffset(point2D);
    }

    private void updateOrientation() {
        this._innerNode.setRotation(this._enzyme.getInnerOrientation());
    }

    private void updateVisibility() {
        this.setVisible(this._enzyme.isEnabled());
    }

    public void update(Observable observable, Object object) {
        if (observable == this._enzyme) {
            if (object == "innerOrientation") {
                this.updateOrientation();
            } else if (object == "enabled") {
                this.updateVisibility();
            }
        }
    }

    public Icon createIcon(double d) {
        boolean bl = this.getVisible();
        this.setVisible(true);
        Image image = this.toImage();
        this.setVisible(bl);
        PImage pImage = new PImage(image);
        double d2 = pImage.getFullBoundsReference().getHeight();
        pImage.setScale(d / d2);
        Image image2 = pImage.toImage();
        ImageIcon imageIcon = new ImageIcon(image2);
        return imageIcon;
    }
}

