/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractChargeNode
extends PhetPNode
implements Observer {
    private static final Color POSITIVE_COLOR = Color.RED;
    private static final Color NEGATIVE_COLOR = Color.BLUE;
    private Bead _bead;
    private Laser _laser;
    private OTModelViewTransform _modelViewTransform;
    private Point2D _pModel;
    private double _maxElectricFieldX;

    public AbstractChargeNode(Bead bead, Laser laser, OTModelViewTransform oTModelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._bead = bead;
        this._bead.addObserver(this);
        this._laser = laser;
        this._laser.addObserver(this);
        this._modelViewTransform = oTModelViewTransform;
        this._pModel = new Point2D.Double();
        this._maxElectricFieldX = this._laser.getMaxElectricFieldX();
        this.initialize();
        this.updatePosition();
    }

    protected abstract void initialize();

    protected Bead getBead() {
        return this._bead;
    }

    protected OTModelViewTransform getModelViewTransform() {
        return this._modelViewTransform;
    }

    protected double getChargeScale(double d) {
        double d2 = Math.abs(d / this._maxElectricFieldX);
        if (d2 < 0.01) {
            d2 = 0.0;
        }
        assert (d2 >= 0.0 && d2 <= 1.0);
        return d2;
    }

    protected static PNode createPositiveNode(double d, double d2) {
        Stroke stroke = AbstractChargeNode.createStroke(d2);
        Line2D.Double double_ = new Line2D.Double(-d / 2.0, 0.0, d / 2.0, 0.0);
        PPath pPath = new PPath(double_);
        pPath.setStrokePaint(POSITIVE_COLOR);
        pPath.setStroke(stroke);
        Line2D.Double double_2 = new Line2D.Double(0.0, -d / 2.0, 0.0, d / 2.0);
        PPath pPath2 = new PPath(double_2);
        pPath2.setStrokePaint(POSITIVE_COLOR);
        pPath2.setStroke(stroke);
        PComposite pComposite = new PComposite();
        pComposite.addChild(pPath);
        pComposite.addChild(pPath2);
        PImage pImage = new PImage(pComposite.toImage());
        return pImage;
    }

    protected static PNode createNegativeNode(double d, double d2) {
        Stroke stroke = AbstractChargeNode.createStroke(d2);
        Line2D.Double double_ = new Line2D.Double(0.0, 0.0, d, 0.0);
        PPath pPath = new PPath(double_);
        pPath.setStrokePaint(NEGATIVE_COLOR);
        pPath.setStroke(stroke);
        PImage pImage = new PImage(pPath.toImage());
        return pImage;
    }

    private static Stroke createStroke(double d) {
        return new BasicStroke((float)d, 0, 2);
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            if (bl) {
                this.updatePosition();
                this.updateCharges();
            }
            super.setVisible(bl);
        }
    }

    public void update(Observable observable, Object object) {
        if (this.isVisible()) {
            if (observable == this._bead) {
                if (object == "position") {
                    this.updatePosition();
                }
            } else if (observable == this._laser && object == "electricField") {
                this.updateCharges();
            }
        }
    }

    private void updatePosition() {
        this._modelViewTransform.modelToView(this._bead.getPositionReference(), this._pModel);
        this.setOffset(this._pModel);
    }

    protected abstract void updateCharges();
}

