/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.persistence;

import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import edu.colorado.phet.opticaltweezers.defaults.PhysicsDefaults;

public class PhysicsConfig
implements IProguardKeepClass {
    private boolean _active;
    private boolean _clockRunning;
    private double _clockDt;
    private double _laserX;
    private boolean _laserRunning;
    private double _laserPower;
    private double _beadX;
    private double _beadY;
    private double _fluidSpeed;
    private double _fluidViscosity;
    private double _fluidTemperature;
    private boolean _laserBeamSelected;
    private boolean _laserElectricFieldSelected;
    private boolean _chargeDistributionSelected;
    private boolean _chargeExcessSelected;
    private boolean _trapForceSelected;
    private boolean _dragForceSelected;
    private boolean _brownianForceEnabled;
    private boolean _positionHistogramSelected;
    private boolean _potentialEnergySelected;
    private boolean _rulerSelected;
    private boolean _isFluidSelected;
    private boolean _isVacuumSelected;
    private boolean _fluidControlsSelected;

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean bl) {
        this._active = bl;
    }

    public boolean isClockRunning() {
        return this._clockRunning;
    }

    public void setClockRunning(boolean bl) {
        this._clockRunning = bl;
    }

    public boolean isFluidSelected() {
        return this._isFluidSelected;
    }

    public void setFluidSelected(boolean bl) {
        this._isFluidSelected = bl;
    }

    public double getBeadX() {
        return this._beadX;
    }

    public void setBeadX(double d) {
        this._beadX = d;
    }

    public double getBeadY() {
        return this._beadY;
    }

    public void setBeadY(double d) {
        this._beadY = d;
    }

    public boolean isBrownianForceEnabled() {
        return this._brownianForceEnabled;
    }

    public void setBrownianForceEnabled(boolean bl) {
        this._brownianForceEnabled = bl;
    }

    public boolean isChargeDistributionSelected() {
        return this._chargeDistributionSelected;
    }

    public void setChargeDistributionSelected(boolean bl) {
        this._chargeDistributionSelected = bl;
    }

    public boolean isChargeExcessSelected() {
        return this._chargeExcessSelected;
    }

    public void setChargeExcessSelected(boolean bl) {
        this._chargeExcessSelected = bl;
    }

    public double getClockDt() {
        return this._clockDt;
    }

    public void setClockDt(double d) {
        if (d < PhysicsDefaults.SLOW_DT_RANGE.getMin() || d > PhysicsDefaults.FAST_DT_RANGE.getMax()) {
            System.err.println("WARNING: clockDt (" + d + ") is out of range, default will be used");
            d = PhysicsDefaults.DEFAULT_DT;
        } else {
            this._clockDt = d;
        }
    }

    public boolean isFluidControlsSelected() {
        return this._fluidControlsSelected;
    }

    public void setFluidControlsSelected(boolean bl) {
        this._fluidControlsSelected = bl;
    }

    public boolean isDragForceSelected() {
        return this._dragForceSelected;
    }

    public void setDragForceSelected(boolean bl) {
        this._dragForceSelected = bl;
    }

    public double getFluidSpeed() {
        return this._fluidSpeed;
    }

    public void setFluidSpeed(double d) {
        if (!PhysicsDefaults.FLUID_SPEED_RANGE.contains(d)) {
            System.err.println("WARNING: fluidSpeed (" + d + ") is out of range, default will be used");
            this._fluidSpeed = PhysicsDefaults.FLUID_SPEED_RANGE.getDefault();
        } else {
            this._fluidSpeed = d;
        }
    }

    public double getFluidTemperature() {
        return this._fluidTemperature;
    }

    public void setFluidTemperature(double d) {
        if (!PhysicsDefaults.FLUID_TEMPERATURE_RANGE.contains(d)) {
            System.err.println("WARNING: fluidTemperature (" + d + ") is out of range, default will be used");
            this._fluidTemperature = PhysicsDefaults.FLUID_TEMPERATURE_RANGE.getDefault();
        } else {
            this._fluidTemperature = d;
        }
    }

    public double getFluidViscosity() {
        return this._fluidViscosity;
    }

    public void setFluidViscosity(double d) {
        if (!PhysicsDefaults.FLUID_VISCOSITY_RANGE.contains(d)) {
            System.err.println("WARNING: fluidViscosity (" + d + ") is out of range, default will be used");
            this._fluidViscosity = PhysicsDefaults.FLUID_VISCOSITY_RANGE.getDefault();
        } else {
            this._fluidViscosity = d;
        }
    }

    public boolean isLaserBeamSelected() {
        return this._laserBeamSelected;
    }

    public void setLaserBeamSelected(boolean bl) {
        this._laserBeamSelected = bl;
    }

    public boolean isLaserElectricFieldSelected() {
        return this._laserElectricFieldSelected;
    }

    public void setLaserElectricFieldSelected(boolean bl) {
        this._laserElectricFieldSelected = bl;
    }

    public double getLaserPower() {
        return this._laserPower;
    }

    public void setLaserPower(double d) {
        if (!PhysicsDefaults.LASER_POWER_RANGE.contains(d)) {
            System.err.println("WARNING: laserPower (" + d + ") is out of range, default will be used");
            this._laserPower = PhysicsDefaults.LASER_POWER_RANGE.getDefault();
        } else {
            this._laserPower = d;
        }
    }

    public boolean isLaserRunning() {
        return this._laserRunning;
    }

    public void setLaserRunning(boolean bl) {
        this._laserRunning = bl;
    }

    public double getLaserX() {
        return this._laserX;
    }

    public void setLaserX(double d) {
        this._laserX = d;
    }

    public boolean isTrapForceSelected() {
        return this._trapForceSelected;
    }

    public void setTrapForceSelected(boolean bl) {
        this._trapForceSelected = bl;
    }

    public boolean isPositionHistogramSelected() {
        return this._positionHistogramSelected;
    }

    public void setPositionHistogramSelected(boolean bl) {
        this._positionHistogramSelected = bl;
    }

    public boolean isPotentialEnergySelected() {
        return this._potentialEnergySelected;
    }

    public void setPotentialEnergySelected(boolean bl) {
        this._potentialEnergySelected = bl;
    }

    public boolean isRulerSelected() {
        return this._rulerSelected;
    }

    public void setRulerSelected(boolean bl) {
        this._rulerSelected = bl;
    }

    public boolean isVacuumSelected() {
        return this._isVacuumSelected;
    }

    public void setVacuumSelected(boolean bl) {
        this._isVacuumSelected = bl;
    }
}

