/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.physics;

import edu.colorado.phet.opticaltweezers.defaults.PhysicsDefaults;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.MicroscopeSlide;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.module.OTAbstractModel;

public class PhysicsModel
extends OTAbstractModel {
    private final Fluid _fluid = new Fluid(PhysicsDefaults.FLUID_SPEED_RANGE, PhysicsDefaults.FLUID_DIRECTION, PhysicsDefaults.FLUID_VISCOSITY_RANGE, PhysicsDefaults.FLUID_TEMPERATURE_RANGE, PhysicsDefaults.FLUID_APT_CONCENTRATION_RANGE);
    private final MicroscopeSlide _microscopeSlide;
    private final Laser _laser;
    private final Bead _bead;
    private final OTModelViewTransform _modelViewTransform;

    public PhysicsModel(OTClock oTClock) {
        super(oTClock);
        this.addModelElement(this._fluid);
        this._microscopeSlide = new MicroscopeSlide(PhysicsDefaults.MICROSCOPE_SLIDE_POSITION, PhysicsDefaults.MICROSCOPE_SLIDE_ORIENTATION, 1000.0, 25.0);
        this.addModelElement(this._microscopeSlide);
        this._laser = new Laser(PhysicsDefaults.LASER_POSITION, PhysicsDefaults.LASER_ORIENTATION, 1000.0, 500.0, 600.0, 100.0, 1064.0, 632.0, PhysicsDefaults.LASER_POWER_RANGE, PhysicsDefaults.LASER_TRAP_FORCE_RATIO, PhysicsDefaults.LASER_ELECTRIC_FIELD_SCALE_RANGE, oTClock);
        this.addModelElement(this._laser);
        this._bead = new Bead(PhysicsDefaults.BEAD_POSITION, PhysicsDefaults.BEAD_ORIENTATION, 200.0, 1.05E-21, this._fluid, this._microscopeSlide, this._laser, PhysicsDefaults.BEAD_BROWNIAN_MOTION_SCALE_RANGE, PhysicsDefaults.BEAD_DT_SUBDIVISION_THRESHOLD_RANGE, PhysicsDefaults.BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE, PhysicsDefaults.BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE, PhysicsDefaults.BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE, PhysicsDefaults.BEAD_VERLET_ACCELERATION_SCALE_RANGE, PhysicsDefaults.BEAD_VACUUM_FAST_THRESHOLD_RANGE, PhysicsDefaults.BEAD_VACUUM_FAST_DT_RANGE, PhysicsDefaults.BEAD_VACUUM_FAST_POWER_RANGE);
        this.addModelElement(this._bead);
        this._modelViewTransform = new OTModelViewTransform(0.5);
    }

    public Fluid getFluid() {
        return this._fluid;
    }

    public MicroscopeSlide getMicroscopeSlide() {
        return this._microscopeSlide;
    }

    public Laser getLaser() {
        return this._laser;
    }

    public Bead getBead() {
        return this._bead;
    }

    public OTModelViewTransform getModelViewTransform() {
        return this._modelViewTransform;
    }
}

