/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.motors;

import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.opticaltweezers.control.ChartsControlPanel;
import edu.colorado.phet.opticaltweezers.control.EnzymeControlPanel;
import edu.colorado.phet.opticaltweezers.control.ForcesControlPanel;
import edu.colorado.phet.opticaltweezers.control.MiscControlPanel;
import edu.colorado.phet.opticaltweezers.control.SimulationSpeedControlPanel;
import edu.colorado.phet.opticaltweezers.control.developer.DeveloperControlPanel;
import edu.colorado.phet.opticaltweezers.defaults.MotorsDefaults;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.module.OTAbstractControlPanel;
import edu.colorado.phet.opticaltweezers.module.motors.MotorsCanvas;
import edu.colorado.phet.opticaltweezers.module.motors.MotorsModel;
import edu.colorado.phet.opticaltweezers.module.motors.MotorsModule;
import java.awt.Frame;

public class MotorsControlPanel
extends OTAbstractControlPanel {
    private MotorsCanvas _canvas;
    private SimulationSpeedControlPanel _simulationSpeedControlPanel;
    private EnzymeControlPanel _enzymeControlPanel;
    private ForcesControlPanel _forcesControlPanel;
    private ChartsControlPanel _chartsControlPanel;
    private MiscControlPanel _miscControlPanel;
    private DeveloperControlPanel _developerControlPanel;

    public MotorsControlPanel(MotorsModule motorsModule, Frame frame) {
        super(motorsModule);
        this._canvas = motorsModule.getMotorsCanvas();
        MotorsModel motorsModel = motorsModule.getMotorsModel();
        this._simulationSpeedControlPanel = new SimulationSpeedControlPanel(TITLE_FONT, CONTROL_FONT, motorsModel.getClock());
        this._enzymeControlPanel = new EnzymeControlPanel(TITLE_FONT, CONTROL_FONT, this._canvas.getEnzymeANode(), this._canvas.getEnzymeBNode());
        this._forcesControlPanel = new ForcesControlPanel(TITLE_FONT, CONTROL_FONT, motorsModel.getBead(), motorsModel.getFluid(), motorsModel.getLaser(), motorsModel.getLaserPositionController(), this._canvas.getTrapForceNode(), this._canvas.getFluidDragForceNode(), this._canvas.getDNAForceNode(), this._canvas.getBeadNode(), this._canvas.getLaserNode());
        this._chartsControlPanel = new ChartsControlPanel(TITLE_FONT, CONTROL_FONT, frame, MotorsDefaults.POSITION_HISTOGRAM_DIALOG_OFFSET, motorsModel.getClock(), motorsModel.getBead(), motorsModel.getLaser(), this._canvas.getPotentialEnergyChartNode(), this._canvas.getLaserNode());
        this._miscControlPanel = new MiscControlPanel(TITLE_FONT, CONTROL_FONT, frame, MotorsDefaults.FLUID_CONTROLS_DIALOG_OFFSET, this._canvas.getRulerNode(), motorsModel.getFluid());
        this._developerControlPanel = new DeveloperControlPanel(TITLE_FONT, CONTROL_FONT, frame, (OTClock)motorsModule.getClock(), motorsModel.getBead(), motorsModel.getInvisibleBead(), motorsModel.getLaser(), motorsModel.getDNAStrandBead(), this._canvas.getDNAStrandBeadNode(), motorsModel.getDNAStrandFree(), this._canvas.getDNAStrandFreeNode(), this._canvas.getTrapForceNode(), this._canvas.getFluidDragForceNode(), this._canvas.getDNAForceNode(), null, null, false);
        this._miscControlPanel.setFluidVacuumPanelVisible(false);
        this.addControlFullWidth(this._simulationSpeedControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._enzymeControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._forcesControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._chartsControlPanel);
        this.addSeparator();
        this.addControlFullWidth(this._miscControlPanel);
        this.addSeparator();
        if (PiccoloPhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addControlFullWidth(this._developerControlPanel);
            this.addSeparator();
        }
        this.addResetAllButton(motorsModule);
    }

    public void closeAllDialogs() {
        this._chartsControlPanel.setPositionHistogramSelected(false);
        this._miscControlPanel.setFluidControlsSelected(false);
    }

    public DeveloperControlPanel getDeveloperControlPanel() {
        return this._developerControlPanel;
    }

    public SimulationSpeedControlPanel getSimulationSpeedControlPanel() {
        return this._simulationSpeedControlPanel;
    }

    public ForcesControlPanel getForcesControlPanel() {
        return this._forcesControlPanel;
    }

    public ChartsControlPanel getChartsControlPanel() {
        return this._chartsControlPanel;
    }

    public MiscControlPanel getMiscControlPanel() {
        return this._miscControlPanel;
    }

    public EnzymeControlPanel getEnzymeControlPanel() {
        return this._enzymeControlPanel;
    }
}

