/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.module.dna;

import edu.colorado.phet.opticaltweezers.defaults.DNADefaults;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.MicroscopeSlide;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.model.OTModelViewTransform;
import edu.colorado.phet.opticaltweezers.module.OTAbstractModel;

public class DNAModel
extends OTAbstractModel {
    private final Fluid _fluid = new Fluid(DNADefaults.FLUID_SPEED_RANGE, DNADefaults.FLUID_DIRECTION, DNADefaults.FLUID_VISCOSITY_RANGE, DNADefaults.FLUID_TEMPERATURE_RANGE, DNADefaults.FLUID_APT_CONCENTRATION_RANGE);
    private final MicroscopeSlide _microscopeSlide;
    private final Laser _laser;
    private final Bead _bead;
    private final DNAStrand _dnaStrand;
    private OTModelViewTransform _modelViewTransform;

    public DNAModel(OTClock oTClock) {
        super(oTClock);
        this.addModelElement(this._fluid);
        this._microscopeSlide = new MicroscopeSlide(DNADefaults.MICROSCOPE_SLIDE_POSITION, DNADefaults.MICROSCOPE_SLIDE_ORIENTATION, 2000.0, 50.0);
        this.addModelElement(this._microscopeSlide);
        this._laser = new Laser(DNADefaults.LASER_POSITION, DNADefaults.LASER_ORIENTATION, 1800.0, 500.0, 1200.0, 200.0, 1064.0, 632.0, DNADefaults.LASER_POWER_RANGE, DNADefaults.LASER_TRAP_FORCE_RATIO, DNADefaults.LASER_ELECTRIC_FIELD_SCALE_RANGE, oTClock);
        this.addModelElement(this._laser);
        this._bead = new Bead(DNADefaults.BEAD_POSITION, DNADefaults.BEAD_ORIENTATION, 200.0, 1.05E-21, this._fluid, this._microscopeSlide, this._laser, DNADefaults.BEAD_BROWNIAN_MOTION_SCALE_RANGE, DNADefaults.BEAD_DT_SUBDIVISION_THRESHOLD_RANGE, DNADefaults.BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE, DNADefaults.BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE, DNADefaults.BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE, DNADefaults.BEAD_VERLET_ACCELERATION_SCALE_RANGE, DNADefaults.BEAD_VACUUM_FAST_THRESHOLD_RANGE, DNADefaults.BEAD_VACUUM_FAST_DT_RANGE, DNADefaults.BEAD_VACUUM_FAST_POWER_RANGE);
        this.addModelElement(this._bead);
        this._dnaStrand = new DNAStrand(DNADefaults.DNA_POSITION, 2413.0, 50.0, 63.5, 0.95, this._bead, this._fluid, oTClock, DNADefaults.DNA_REFERENCE_CLOCK_STEP, DNADefaults.DNA_SPRING_CONSTANT_RANGE, DNADefaults.DNA_DRAG_COEFFICIENT_RANGE, DNADefaults.DNA_KICK_CONSTANT_RANGE, DNADefaults.DNA_NUMBER_OF_EVOLUTIONS_PER_CLOCK_STEP_RANGE, DNADefaults.DNA_EVOLUTION_DT_RANGE, DNADefaults.DNA_FLUID_DRAG_COEFFICIENT_RANGE);
        this.addModelElement(this._dnaStrand);
        this._bead.attachTo(this._dnaStrand);
        this._modelViewTransform = new OTModelViewTransform(0.25);
    }

    public Fluid getFluid() {
        return this._fluid;
    }

    public MicroscopeSlide getMicroscopeSlide() {
        return this._microscopeSlide;
    }

    public Laser getLaser() {
        return this._laser;
    }

    public Bead getBead() {
        return this._bead;
    }

    public DNAStrand getDNAStrand() {
        return this._dnaStrand;
    }

    public OTModelViewTransform getModelViewTransform() {
        return this._modelViewTransform;
    }
}

