/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.model;

import edu.colorado.phet.opticaltweezers.model.IDNASpeedStrategy;

public abstract class TomDNASpeedStrategy
implements IDNASpeedStrategy {
    private final double _maxSpeed;
    private final double _kt;
    private final double _kcat0;
    private final double _kb0;
    private final double _pc;
    private final double _qc;
    private final double _pb;
    private final double _qb;
    private final double _deltaCat;
    private final double _deltaB;
    private final double _d;

    protected TomDNASpeedStrategy(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        this._maxSpeed = d;
        this._kt = d2;
        this._kcat0 = d3;
        this._kb0 = d4;
        this._pc = d5;
        this._qc = d6;
        this._pb = d7;
        this._qb = d8;
        this._deltaCat = d9;
        this._deltaB = d10;
        this._d = d11;
    }

    public double getSpeed(double d, double d2) {
        double d3 = Math.exp(d2 * this._deltaCat / this._kt);
        double d4 = Math.exp(d2 * this._deltaB / this._kt);
        double d5 = this._kcat0 / (this._pc + this._qc * d3);
        double d6 = this._kb0 / (this._pb + this._qb * d4);
        double d7 = this._d * d5 * d / (d + d5 / d6);
        return d7;
    }

    public double getMaxSpeed() {
        return this._maxSpeed;
    }

    public static class TomDNASpeedStrategyA
    extends TomDNASpeedStrategy {
        public TomDNASpeedStrategyA() {
            super(5000.0, 4.1, 700.0, 350.0, 1.0, 0.09, 2.0, 0.1, 3.28, 4.8, 8.0);
        }
    }

    public static class TomDNASpeedStrategyB
    extends TomDNASpeedStrategy {
        public TomDNASpeedStrategyB() {
            super(5000.0, 4.1, 6500.0, 3250.0, 10.0, 0.09, 20.0, 0.1, 0.04, 5.6, 8.0);
        }
    }
}

