/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.model;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;

public class OTClock
extends ConstantDtClock {
    private final DoubleRange _slowRange;
    private final DoubleRange _fastRange;

    public OTClock(int n, DoubleRange doubleRange, DoubleRange doubleRange2, double d) {
        super(1000 / n, d);
        if (doubleRange.getMax() > doubleRange2.getMin()) {
            throw new IllegalArgumentException("slowRange and fastRange overlap");
        }
        if (d < doubleRange.getMin() || d > doubleRange2.getMax()) {
            throw new IllegalArgumentException("dt out of range: " + d);
        }
        this._slowRange = doubleRange;
        this._fastRange = doubleRange2;
    }

    public void setDt(double d) {
        super.setDt(d);
        this.resetSimulationTime();
    }

    public DoubleRange getSlowRange() {
        return this._slowRange;
    }

    public DoubleRange getFastRange() {
        return this._fastRange;
    }

    public double getMaxDt() {
        return this._fastRange.getMax();
    }
}

