/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.OTObservable;
import java.awt.geom.Point2D;

public class LaserPositionController
extends OTObservable
implements ModelElement {
    private Laser _laser;
    private DNAStrand _dnaStrand;
    private boolean _enabled;
    private double _previousExtension;

    public LaserPositionController(Laser laser, DNAStrand dNAStrand) {
        this._laser = laser;
        this._dnaStrand = dNAStrand;
        this._enabled = false;
        this._previousExtension = 0.0;
    }

    public void setEnabled(boolean bl) {
        if (bl != this._enabled) {
            this._enabled = bl;
            this._previousExtension = this._dnaStrand.getExtension();
            this.notifyObservers("enabled");
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    private void moveLaser() {
        double d = this._dnaStrand.getExtension();
        double d2 = d - this._previousExtension;
        this._previousExtension = d;
        Point2D point2D = this._laser.getPositionReference();
        this._laser.setPosition(point2D.getX() + d2, point2D.getY());
    }

    public void stepInTime(double d) {
        if (this._enabled && this._laser.isRunning() && this._laser.getPower() > 0.0) {
            this.moveLaser();
        }
    }
}

