/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.model;

import edu.colorado.phet.common.phetcommon.math.PolarCartesianConverter;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.opticaltweezers.model.AbstractEnzyme;
import edu.colorado.phet.opticaltweezers.model.Bead;
import edu.colorado.phet.opticaltweezers.model.DNAPivot;
import edu.colorado.phet.opticaltweezers.model.FixedObject;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import edu.colorado.phet.opticaltweezers.util.OTVector2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;

public class DNAStrand
extends FixedObject
implements ModelElement,
Observer {
    private Bead _bead;
    private Fluid _fluid;
    private OTClock _clock;
    private double _referenceClockStep;
    private AbstractEnzyme _enzyme;
    private double _contourLength;
    private final double _persistenceLength;
    private final double _springLength;
    private ArrayList _pivots;
    private double _springLengthClosestToPin;
    private final double _stretchiness;
    private Random _kickRandom;
    private OTVector2D _someVector;
    private double _springConstant;
    private DoubleRange _springConstantRange;
    private double _dragCoefficient;
    private DoubleRange _dragCoefficientRange;
    private double _kickConstant;
    private DoubleRange _kickConstantRange;
    private int _numberOfEvolutionsPerClockTick;
    private IntegerRange _numberOfEvolutionsPerClockTickRange;
    private double _evolutionDt;
    private DoubleRange _evolutionDtRange;
    private double _fluidDragCoefficient;
    private DoubleRange _fluidDragCoefficientRange;

    public DNAStrand(Point2D point2D, double d, double d2, double d3, double d4, Bead bead, Fluid fluid, OTClock oTClock, double d5, DoubleRange doubleRange, DoubleRange doubleRange2, DoubleRange doubleRange3, IntegerRange integerRange, DoubleRange doubleRange4, DoubleRange doubleRange5) {
        super(point2D, 0.0);
        this._contourLength = d;
        this._persistenceLength = d2;
        this._springLength = d3;
        this._stretchiness = d4;
        this._bead = bead;
        this._bead.addObserver(this);
        this._fluid = fluid;
        this._fluid.addObserver(this);
        this._clock = oTClock;
        this._referenceClockStep = d5;
        this._kickRandom = new Random();
        this._someVector = new OTVector2D.Cartesian();
        this._springConstantRange = doubleRange;
        this._springConstant = this._springConstantRange.getDefault();
        this._dragCoefficientRange = doubleRange2;
        this._dragCoefficient = this._dragCoefficientRange.getDefault();
        this._kickConstantRange = doubleRange3;
        this._kickConstant = this._kickConstantRange.getDefault();
        this._numberOfEvolutionsPerClockTickRange = integerRange;
        this._numberOfEvolutionsPerClockTick = this._numberOfEvolutionsPerClockTickRange.getDefault();
        this._evolutionDtRange = doubleRange4;
        this._evolutionDt = this._evolutionDtRange.getDefault();
        this._fluidDragCoefficientRange = doubleRange5;
        this._fluidDragCoefficient = this._fluidDragCoefficientRange.getDefault();
        this.initializePivots();
    }

    public ArrayList getPivots() {
        return this._pivots;
    }

    public double setContourLength(double d) {
        if (d != this._contourLength) {
            if (d > this._contourLength) {
                this.makeLonger(d - this._contourLength);
            } else if (d < this._contourLength) {
                this.makeShorter(this._contourLength - d);
            }
            this.notifyObservers("shape");
            this.notifyObservers("force");
        }
        return this._contourLength;
    }

    public double getContourLength() {
        return this._contourLength;
    }

    public double getExtension() {
        return this.getExtension(this.getBeadX(), this.getBeadY());
    }

    private double getExtension(double d, double d2) {
        double d3 = d - this.getPinX();
        double d4 = d2 - this.getPinY();
        return PolarCartesianConverter.getRadius(d3, d4);
    }

    public double getMaxExtension() {
        return this._stretchiness * this._contourLength;
    }

    public void attachEnzyme(AbstractEnzyme abstractEnzyme) {
        this._enzyme = abstractEnzyme;
    }

    public double getPinX() {
        return this.getX();
    }

    public double getPinY() {
        return this.getY();
    }

    public double getBeadX() {
        return this._bead.getX();
    }

    public double getBeadY() {
        return this._bead.getY();
    }

    public void setSpringConstant(double d) {
        if (!this._springConstantRange.contains(d)) {
            throw new IllegalArgumentException("springConstant out of range: " + d);
        }
        if (d != this._springConstant) {
            this._springConstant = d;
            this.notifyObservers("springConstant");
        }
    }

    public double getSpringConstant() {
        return this._springConstant;
    }

    public DoubleRange getSpringConstantRange() {
        return this._springConstantRange;
    }

    public void setDragCoefficient(double d) {
        if (!this._dragCoefficientRange.contains(d)) {
            throw new IllegalArgumentException("dragCoefficient out of range: " + d);
        }
        if (d != this._dragCoefficient) {
            this._dragCoefficient = d;
            this.notifyObservers("dragCoefficient");
        }
    }

    public double getDragCoefficient() {
        return this._dragCoefficient;
    }

    public DoubleRange getDragCoefficientRange() {
        return this._dragCoefficientRange;
    }

    public void setKickConstant(double d) {
        if (!this._kickConstantRange.contains(d)) {
            throw new IllegalArgumentException("kickConstant out of range: " + d);
        }
        if (d != this._kickConstant) {
            this._kickConstant = d;
            this.notifyObservers("kickConstant");
        }
    }

    public double getKickConstant() {
        return this._kickConstant;
    }

    public DoubleRange getKickConstantRange() {
        return this._kickConstantRange;
    }

    public void setNumberOfEvolutionsPerClockTick(int n) {
        if (!this._numberOfEvolutionsPerClockTickRange.contains(n)) {
            throw new IllegalArgumentException("numberOfEvolutionsPerClockTick out of range: " + n);
        }
        if (n != this._numberOfEvolutionsPerClockTick) {
            this._numberOfEvolutionsPerClockTick = n;
            this.notifyObservers("numberOfEvolutionsPerClockTick");
        }
    }

    public int getNumberOfEvolutionsPerClockTick() {
        return this._numberOfEvolutionsPerClockTick;
    }

    public IntegerRange getNumberOfEvolutionsPerClockTickRange() {
        return this._numberOfEvolutionsPerClockTickRange;
    }

    public void setEvolutionDt(double d) {
        if (!this._evolutionDtRange.contains(d)) {
            throw new IllegalArgumentException("evolutionDt out of range: " + d);
        }
        if (d != this._evolutionDt) {
            this._evolutionDt = d;
            this.notifyObservers("evolutionDtScale");
        }
    }

    public double getEvolutionDt() {
        return this._evolutionDt;
    }

    public DoubleRange getEvolutionDtRange() {
        return this._evolutionDtRange;
    }

    public void setFluidDragCoefficient(double d) {
        if (!this._fluidDragCoefficientRange.contains(d)) {
            new IllegalArgumentException("fluidDragCoefficient out of range: " + d);
        }
        if (d != this._fluidDragCoefficient) {
            this._fluidDragCoefficient = d;
            this.notifyObservers("fluidDragCoefficient");
        }
    }

    public double getFluidDragCoefficient() {
        return this._fluidDragCoefficient;
    }

    public DoubleRange getFluidDragCoefficientRange() {
        return this._fluidDragCoefficientRange;
    }

    public OTVector2D getForce(Point2D point2D) {
        return this.getForce(point2D.getX(), point2D.getY());
    }

    public OTVector2D getForce(double d, double d2) {
        double d3 = this.getPinX() - d;
        double d4 = this.getPinY() - d2;
        double d5 = PolarCartesianConverter.getAngle(d3, d4);
        double d6 = 0.0;
        if (this.isShortAsPossible() && this._enzyme != null) {
            d6 = this._enzyme.getStallForceMagnitude(this._fluid.getATPConcentration());
        } else {
            double d7 = this.getExtension(d, d2);
            double d8 = 4.1 * this._fluid.getTemperature() / 293.0;
            double d9 = this._persistenceLength;
            double d10 = d7 / this._contourLength;
            if (this.getNumberOfSprings() == 1) {
                d10 = this._stretchiness;
            }
            d6 = d8 / d9 * (1.0 / (4.0 * (1.0 - d10) * (1.0 - d10)) - 0.24 + d10);
        }
        return new OTVector2D.Polar(d6, d5);
    }

    public OTVector2D getForceAtBead() {
        return this.getForce(this.getBeadX(), this.getBeadY());
    }

    public void initializePivots() {
        double d;
        Point2D point2D;
        assert (this._contourLength >= this._springLength);
        Point2D point2D2 = this.getPositionReference();
        double d2 = Math.abs(point2D2.distance(point2D = this._bead.getPositionReference()));
        if (d2 > (d = this._contourLength * this._stretchiness)) {
            throw new IllegalStateException("cannot connect DNA strand to bead, bead is too far away from pin");
        }
        this._pivots = new ArrayList();
        if (this._contourLength == this._springLength) {
            this._pivots.add(new DNAPivot(this.getPinX(), this.getPinY()));
            this._pivots.add(new DNAPivot(this.getBeadX(), point2D.getY()));
            this._springLengthClosestToPin = this._springLength;
        } else {
            int n = (int)(this._contourLength / this._springLength) + 2;
            this._springLengthClosestToPin = this._contourLength % this._springLength;
            if (this._springLengthClosestToPin == 0.0) {
                this._springLengthClosestToPin = this._springLength;
                --n;
            }
            assert (this._springLengthClosestToPin <= this._springLength);
            assert (this._springLengthClosestToPin > 0.0);
            double d3 = d2 / this._contourLength;
            double d4 = PolarCartesianConverter.getAngle(point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY());
            DNAPivot dNAPivot = new DNAPivot(this.getPinX(), this.getPinY());
            this._pivots.add(dNAPivot);
            DNAPivot dNAPivot2 = dNAPivot;
            double d5 = d3 * PolarCartesianConverter.getX(this._springLengthClosestToPin, d4);
            double d6 = d3 * PolarCartesianConverter.getY(this._springLengthClosestToPin, d4);
            dNAPivot = new DNAPivot(dNAPivot.getX() + d5, dNAPivot.getY() + d6);
            this._pivots.add(dNAPivot);
            dNAPivot2 = dNAPivot;
            d5 = d3 * PolarCartesianConverter.getX(this._springLength, d4);
            d6 = d3 * PolarCartesianConverter.getY(this._springLength, d4);
            for (int i = 0; i < n - 3; ++i) {
                dNAPivot = new DNAPivot(dNAPivot2.getX() + d5, dNAPivot2.getY() + d6);
                this._pivots.add(dNAPivot);
                dNAPivot2 = dNAPivot;
            }
            dNAPivot = new DNAPivot(this.getBeadX(), point2D.getY());
            this._pivots.add(dNAPivot);
        }
        this.evolvePivots(this._clock.getMaxDt());
        this.notifyObservers("shape");
    }

    private void evolvePivots(double d) {
        if (this._pivots.size() < 3) {
            return;
        }
        double d2 = Math.min(1.0, this.getExtension() / this._contourLength);
        double d3 = Math.sqrt(1.0 - d2);
        double d4 = d / this._referenceClockStep;
        double d5 = this._evolutionDt * d4;
        for (int i = 0; i < this._numberOfEvolutionsPerClockTick; ++i) {
            int n = this._pivots.size();
            for (int j = 1; j < n - 1; ++j) {
                DNAPivot dNAPivot = (DNAPivot)this._pivots.get(j);
                DNAPivot dNAPivot2 = (DNAPivot)this._pivots.get(j - 1);
                DNAPivot dNAPivot3 = (DNAPivot)this._pivots.get(j + 1);
                double d6 = dNAPivot.getX() + dNAPivot.getXVelocity() * d5 + 0.5 * dNAPivot.getXAcceleration() * d5 * d5;
                double d7 = dNAPivot.getY() + dNAPivot.getYVelocity() * d5 + 0.5 * dNAPivot.getYAcceleration() * d5 * d5;
                dNAPivot.setPosition(d6, d7);
                double d8 = dNAPivot.getX() - dNAPivot2.getX();
                double d9 = dNAPivot.getY() - dNAPivot2.getY();
                double d10 = dNAPivot3.getX() - dNAPivot.getX();
                double d11 = dNAPivot3.getY() - dNAPivot.getY();
                double d12 = Math.max(0.01, PolarCartesianConverter.getRadius(d8, d9));
                double d13 = Math.max(0.01, PolarCartesianConverter.getRadius(d10, d11));
                double d14 = 1.0 - d3 * this._springLength / d12;
                double d15 = 1.0 - d3 * this._springLength / d13;
                this._fluid.getVelocity(this._someVector);
                double d16 = this._fluidDragCoefficient * this._someVector.getX();
                double d17 = this._fluidDragCoefficient * this._someVector.getY();
                assert (d17 == 0.0);
                double d18 = this._springConstant;
                if (j == 1 && this._springLengthClosestToPin < this._springLength) {
                    d18 += (50.0 - this._springConstant) * ((this._springLength - this._springLengthClosestToPin) / this._springLength);
                }
                double d19 = d18 * (d10 * d15 - d8 * d14) - this._dragCoefficient * dNAPivot.getXVelocity() + d16;
                double d20 = d18 * (d11 * d15 - d9 * d14) - this._dragCoefficient * dNAPivot.getYVelocity() + d17;
                dNAPivot.setAcceleration(d19, d20);
                double d21 = this._kickConstant * Math.sqrt(d4);
                double d22 = dNAPivot.getXVelocity() + dNAPivot.getXAcceleration() * d5 + d21 * (this._kickRandom.nextDouble() - 0.5);
                double d23 = dNAPivot.getYVelocity() + dNAPivot.getYAcceleration() * d5 + d21 * (this._kickRandom.nextDouble() - 0.5);
                dNAPivot.setVelocity(d22, d23);
            }
        }
    }

    private void makeLonger(double d) {
        assert (d > 0.0);
        double d2 = d;
        if (this._springLengthClosestToPin != this._springLength) {
            double d3 = this._springLength - this._springLengthClosestToPin;
            if (d2 <= d3) {
                this._springLengthClosestToPin += d2;
                d2 = 0.0;
            } else {
                this._springLengthClosestToPin = this._springLength;
                d2 -= d3;
            }
        }
        while (d2 >= this._springLength) {
            this.addSpringAtPin(this._springLength);
            d2 -= this._springLength;
        }
        if (d2 > 0.0) {
            this.addSpringAtPin(d2);
            d2 = 0.0;
        }
        this._contourLength += d;
        assert (this._contourLength >= this._springLength);
        assert (this._springLengthClosestToPin > 0.0 && this._springLengthClosestToPin <= this._springLength);
        assert (d2 == 0.0);
    }

    private void makeShorter(double d) {
        assert (d > 0.0);
        if (!this.isShortAsPossible()) {
            double d2 = d;
            double d3 = 0.0;
            if (d2 < this._springLengthClosestToPin) {
                this._springLengthClosestToPin -= d2;
                d3 += d2;
                d2 = 0.0;
            } else {
                d3 += this._springLengthClosestToPin;
                d2 -= this._springLengthClosestToPin;
                this.removeSpringAtPin();
                while (d2 >= this._springLength && !this.isShortAsPossible()) {
                    this.removeSpringAtPin();
                    d3 += this._springLength;
                    d2 -= this._springLength;
                }
                if (d2 > 0.0 && d2 < this._springLength && !this.isShortAsPossible()) {
                    this._springLengthClosestToPin = this._springLength - d2;
                    d3 += d2;
                    d2 = 0.0;
                }
            }
            this._contourLength -= d3;
            if (this._contourLength < this._springLength) {
                System.err.println("DNAStrand.makeShorter: contour length is too short, adjusting: " + this._contourLength);
                this._contourLength = this._springLength;
            }
            assert (this.getNumberOfSprings() > 0);
            assert (this._contourLength >= this._springLength);
            assert (this._springLengthClosestToPin > 0.0 && this._springLengthClosestToPin <= this._springLength);
            assert (d3 >= 0.0 && d3 <= d);
        }
    }

    private void addSpringAtPin(double d) {
        DNAPivot dNAPivot = new DNAPivot(this.getPinX(), this.getPinY());
        this._pivots.add(1, dNAPivot);
        this._springLengthClosestToPin = d;
    }

    private void removeSpringAtPin() {
        if (this.isShortAsPossible()) {
            throw new IllegalStateException("cannot remove the last spring!");
        }
        this._pivots.remove(1);
        this._springLengthClosestToPin = this._springLength;
    }

    private int getNumberOfSprings() {
        return this._pivots.size() - 1;
    }

    private boolean isShortAsPossible() {
        return this.getNumberOfSprings() == 1;
    }

    public void update(Observable observable, Object object) {
        if (observable == this._bead) {
            if (object == "position") {
                DNAPivot dNAPivot = (DNAPivot)this._pivots.get(this._pivots.size() - 1);
                dNAPivot.setPosition(this._bead.getX(), this._bead.getY());
                if (!this._clock.isRunning()) {
                    this.evolvePivots(this._clock.getMaxDt());
                }
                this.notifyObservers("shape");
            }
        } else if (observable == this._fluid && object == "temperature") {
            this.notifyObservers("force");
        }
    }

    public void stepInTime(double d) {
        this.evolvePivots(d);
        this.notifyObservers("shape");
    }
}

