/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.opticaltweezers.model.DNAStrand;
import edu.colorado.phet.opticaltweezers.model.Fluid;
import edu.colorado.phet.opticaltweezers.model.Laser;
import edu.colorado.phet.opticaltweezers.model.MicroscopeSlide;
import edu.colorado.phet.opticaltweezers.model.MovableObject;
import edu.colorado.phet.opticaltweezers.util.OTVector2D;
import java.awt.geom.Point2D;
import java.util.Random;

public class Bead
extends MovableObject
implements ModelElement {
    private static final OTVector2D ZERO_VECTOR = new OTVector2D.Cartesian(0.0, 0.0);
    private final double _diameter;
    private final double _density;
    private final Fluid _fluid;
    private final MicroscopeSlide _microscopeSlide;
    private final Laser _laser;
    private final Random _stepAngleRandom;
    private boolean _motionEnabled;
    private boolean _brownianMotionEnabled;
    private final OTVector2D _velocity;
    private DNAStrand _dnaStrand;
    private double _brownianMotionScale;
    private final DoubleRange _brownianMotionScaleRange;
    private double _dtSubdivisionThreshold;
    private final DoubleRange _dtSubdivisionThresholdRange;
    private int _numberOfDtSubdivisions;
    private final IntegerRange _numberOfDtSubdivisionsRange;
    private double _verletDtSubdivisionThreshold;
    private final DoubleRange _verletDtSubdivisionThresholdRange;
    private int _verletNumberOfDtSubdivisions;
    private final IntegerRange _verletNumberOfDtSubdivisionsRange;
    private double _verletAccelerationScale;
    private final DoubleRange _verletAccelerationScaleRange;
    private double _vacuumFastThreshold;
    private final DoubleRange _vacuumFastThresholdRange;
    private double _vacuumFastDt;
    private final DoubleRange _vacuumFastDtRange;
    private double _vacuumFastPower;
    private final DoubleRange _vacuumFastPowerRange;

    public Bead(Point2D point2D, double d, double d2, double d3, Fluid fluid, MicroscopeSlide microscopeSlide, Laser laser, DoubleRange doubleRange, DoubleRange doubleRange2, IntegerRange integerRange, DoubleRange doubleRange3, IntegerRange integerRange2, DoubleRange doubleRange4, DoubleRange doubleRange5, DoubleRange doubleRange6, DoubleRange doubleRange7) {
        super(point2D, d, 0.0);
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("diameter must be > 0: " + d2);
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("density must be > 0: " + d3);
        }
        this._diameter = d2;
        this._density = d3;
        this._microscopeSlide = microscopeSlide;
        this._fluid = fluid;
        this._laser = laser;
        this._stepAngleRandom = new Random();
        this._motionEnabled = true;
        this._brownianMotionEnabled = true;
        this._velocity = new OTVector2D.Cartesian();
        this._brownianMotionScaleRange = doubleRange;
        this._dtSubdivisionThresholdRange = doubleRange2;
        this._numberOfDtSubdivisionsRange = integerRange;
        this._verletDtSubdivisionThresholdRange = doubleRange3;
        this._verletNumberOfDtSubdivisionsRange = integerRange2;
        this._verletAccelerationScaleRange = doubleRange4;
        this._vacuumFastThresholdRange = doubleRange5;
        this._vacuumFastDtRange = doubleRange6;
        this._vacuumFastPowerRange = doubleRange7;
        this._brownianMotionScale = doubleRange.getDefault();
        this._dtSubdivisionThreshold = doubleRange2.getDefault();
        this._numberOfDtSubdivisions = integerRange.getDefault();
        this._verletDtSubdivisionThreshold = doubleRange3.getDefault();
        this._verletNumberOfDtSubdivisions = integerRange2.getDefault();
        this._verletAccelerationScale = doubleRange4.getDefault();
        this._vacuumFastThreshold = doubleRange5.getDefault();
        this._vacuumFastDt = doubleRange6.getDefault();
        this._vacuumFastPower = doubleRange7.getDefault();
    }

    public double getDiameter() {
        return this._diameter;
    }

    public double getMass() {
        double d = this._diameter / 2.0;
        double d2 = 4.1887902047863905 * (d * d * d);
        return d2 * this._density;
    }

    public void setMotionEnabled(boolean bl) {
        if (bl != this._motionEnabled) {
            this._motionEnabled = bl;
            this._velocity.setXY(0.0, 0.0);
        }
    }

    public void setBrownianMotionEnabled(boolean bl) {
        if (bl != this._brownianMotionEnabled) {
            this._brownianMotionEnabled = bl;
            this.notifyObservers("brownianMotionEnabled");
        }
    }

    public boolean isBrownianMotionEnabled() {
        return this._brownianMotionEnabled;
    }

    public OTVector2D getDragForce() {
        OTVector2D oTVector2D = ZERO_VECTOR;
        if (this._fluid.isEnabled()) {
            oTVector2D = this._fluid.getDragForce(this._velocity, this._diameter);
        }
        return oTVector2D;
    }

    public OTVector2D getTrapForce() {
        OTVector2D oTVector2D = ZERO_VECTOR;
        if (this._laser != null) {
            oTVector2D = this._laser.getTrapForce(this.getX(), this.getY());
        }
        return oTVector2D;
    }

    public double getPotentialEnergy() {
        double d = 0.0;
        if (this._laser != null) {
            d = this._laser.getPotentialEnergy(this.getX(), this.getY());
        }
        return d;
    }

    public void attachTo(DNAStrand dNAStrand) {
        this._dnaStrand = dNAStrand;
    }

    public DNAStrand getDNAStrand() {
        return this._dnaStrand;
    }

    public double getElectricFieldX() {
        double d = 0.0;
        if (this._laser != null) {
            double d2 = this._position.getX() - this._laser.getPositionReference().getX();
            double d3 = this._position.getY() - this._laser.getPositionReference().getY();
            d = this._laser.getElectricFieldX(d2, d3);
        }
        return d;
    }

    public void setBrownianMotionScale(double d) {
        if (!this._brownianMotionScaleRange.contains(d)) {
            throw new IllegalArgumentException("brownianMotionScale out of range: " + d);
        }
        if (d != this._brownianMotionScale) {
            this._brownianMotionScale = d;
            this.notifyObservers("brownianMotionScale");
        }
    }

    public double getBrownianMotionScale() {
        return this._brownianMotionScale;
    }

    public DoubleRange getBrownianMotionScaleRange() {
        return this._brownianMotionScaleRange;
    }

    public void setDtSubdivisionThreshold(double d) {
        if (!this._dtSubdivisionThresholdRange.contains(d)) {
            throw new IllegalArgumentException("dtSubdivisionThreshold out of range: " + d);
        }
        if (d != this._dtSubdivisionThreshold) {
            this._dtSubdivisionThreshold = d;
            this.notifyObservers("dtSubdivisionThreshold");
        }
    }

    public double getDtSubdivisionThreshold() {
        return this._dtSubdivisionThreshold;
    }

    public DoubleRange getDtSubdivisionThresholdRange() {
        return this._dtSubdivisionThresholdRange;
    }

    public void setNumberOfDtSubdivisions(int n) {
        if (!this._numberOfDtSubdivisionsRange.contains(n)) {
            throw new IllegalArgumentException("numberOfSubdivisions out of range: " + n);
        }
        if (n != this._numberOfDtSubdivisions) {
            this._numberOfDtSubdivisions = n;
            this.notifyObservers("numberOfDtSubdivisions");
        }
    }

    public int getNumberOfDtSubdivisions() {
        return this._numberOfDtSubdivisions;
    }

    public IntegerRange getNumberOfDtSubdivisionsRange() {
        return this._numberOfDtSubdivisionsRange;
    }

    public void setVerletAccelerationScale(double d) {
        if (!this._verletAccelerationScaleRange.contains(d)) {
            throw new IllegalArgumentException("verletAccelerationScale out of range: " + d);
        }
        if (d != this._verletAccelerationScale) {
            this._verletAccelerationScale = d;
            this.notifyObservers("verletAccelerationScale");
        }
    }

    public double getVerletAccelerationScale() {
        return this._verletAccelerationScale;
    }

    public DoubleRange getVerletAccelerationScaleRange() {
        return this._verletAccelerationScaleRange;
    }

    public void setVerletDtSubdivisionThreshold(double d) {
        if (!this._verletDtSubdivisionThresholdRange.contains(d)) {
            throw new IllegalArgumentException("verletDtSubdivisionThreshold out of range: " + d);
        }
        if (d != this._verletDtSubdivisionThreshold) {
            this._verletDtSubdivisionThreshold = d;
            this.notifyObservers("verletDtSubdivisionThreshold");
        }
    }

    public double getVerletDtSubdivisionThreshold() {
        return this._verletDtSubdivisionThreshold;
    }

    public DoubleRange getVerletDtSubdivisionThresholdRange() {
        return this._verletDtSubdivisionThresholdRange;
    }

    public void setVerletNumberOfDtSubdivisions(int n) {
        if (!this._verletNumberOfDtSubdivisionsRange.contains(n)) {
            throw new IllegalArgumentException("verletNumberOfDtSubdivisions out of range: " + n);
        }
        if (n != this._verletNumberOfDtSubdivisions) {
            this._verletNumberOfDtSubdivisions = n;
            this.notifyObservers("verletNumberOfDtSubdivisions");
        }
    }

    public int getVerletNumberOfDtSubdivisions() {
        return this._verletNumberOfDtSubdivisions;
    }

    public IntegerRange getVerletNumberOfDtSubdivisionsRange() {
        return this._verletNumberOfDtSubdivisionsRange;
    }

    public void setVacuumFastThreshold(double d) {
        if (!this._vacuumFastThresholdRange.contains(d)) {
            throw new IllegalArgumentException("vacuumFastThreshold out of range: " + d);
        }
        if (this._vacuumFastThreshold != d) {
            this._vacuumFastThreshold = d;
            this.notifyObservers("vacuumFastThreshold");
        }
    }

    public double getVacuumFastThreshold() {
        return this._vacuumFastThreshold;
    }

    public DoubleRange getVacuumFastThresholdRange() {
        return this._vacuumFastThresholdRange;
    }

    public void setVacuumFastDt(double d) {
        if (!this._vacuumFastDtRange.contains(d)) {
            throw new IllegalArgumentException("vacuumFastDt out of range: " + d);
        }
        if (this._vacuumFastDt != d) {
            this._vacuumFastDt = d;
            this.notifyObservers("vacuumFastDt");
        }
    }

    public double getVacuumFastDt() {
        return this._vacuumFastDt;
    }

    public DoubleRange getVacuumFastDtRange() {
        return this._vacuumFastDtRange;
    }

    public void setVacuumFastPower(double d) {
        if (!this._vacuumFastPowerRange.contains(d)) {
            throw new IllegalArgumentException("vacuumFastPower out of range: " + d);
        }
        if (this._vacuumFastPower != d) {
            this._vacuumFastPower = d;
            this.notifyObservers("vacuumFastPower");
        }
    }

    public double getVacuumFastPower() {
        return this._vacuumFastPower;
    }

    public DoubleRange getVacuumFastPowerRange() {
        return this._vacuumFastPowerRange;
    }

    public void stepInTime(double d) {
        if (this._motionEnabled) {
            this.move(d);
        }
    }

    private void move(double d) {
        if (this._fluid.isEnabled()) {
            this.moveInFluid(d);
        } else {
            this.moveInVacuum(d);
        }
    }

    private void moveInVacuum(double d) {
        double d2 = this._microscopeSlide.getCenterMinY() + this.getDiameter() / 2.0;
        double d3 = this._microscopeSlide.getCenterMaxY() - this.getDiameter() / 2.0;
        double d4 = this.getMass() / 1000.0;
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this._velocity.getX();
        double d8 = this._velocity.getY();
        boolean bl = false;
        OTVector2D oTVector2D = ZERO_VECTOR;
        if (this._laser != null) {
            boolean bl2 = bl = this._laser.isRunning() && this._laser.getPower() * d >= this._vacuumFastThreshold;
            if (bl) {
                d = this._vacuumFastDt;
                oTVector2D = this._laser.getTrapForce(d5, d6, this._vacuumFastPower);
            } else {
                oTVector2D = this._laser.getTrapForce(d5, d6);
            }
        }
        double d9 = this._verletAccelerationScale * 0.001 * oTVector2D.getX() / d4;
        double d10 = this._verletAccelerationScale * 0.001 * oTVector2D.getY() / d4;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = d;
        int n = 1;
        if (d > 1.001 * this._verletDtSubdivisionThreshold) {
            d17 = d / (double)this._verletNumberOfDtSubdivisions;
            n = this._verletNumberOfDtSubdivisions;
        }
        for (int i = 0; i < n; ++i) {
            d11 = d5 + d7 * d17 + 0.5 * d9 * d17 * d17;
            d12 = d6 + d8 * d17 + 0.5 * d10 * d17 * d17;
            if (d12 < d2) {
                d12 = d2;
            } else if (d12 > d3) {
                d12 = d3;
            }
            oTVector2D = ZERO_VECTOR;
            if (this._laser != null) {
                oTVector2D = bl ? this._laser.getTrapForce(d11, d12, this._vacuumFastPower) : this._laser.getTrapForce(d11, d12);
            }
            d15 = this._verletAccelerationScale * 0.001 * oTVector2D.getX() / d4;
            d16 = this._verletAccelerationScale * 0.001 * oTVector2D.getY() / d4;
            d13 = d7 + 0.5 * (d15 + d9) * d17;
            d14 = d8 + 0.5 * (d16 + d10) * d17;
            d5 = d11;
            d6 = d12;
            d7 = d13;
            d8 = d14;
            d9 = d15;
            d10 = d16;
        }
        this._velocity.setXY(d13, d14);
        this.setPosition(d11, d12);
    }

    private void moveInFluid(double d) {
        double d2 = this._microscopeSlide.getCenterMinY() + this.getDiameter() / 2.0;
        double d3 = this._microscopeSlide.getCenterMaxY() - this.getDiameter() / 2.0;
        double d4 = this._fluid.getDimensionlessNormalizedViscosity();
        double d5 = this._fluid.getMobility(this._diameter);
        OTVector2D oTVector2D = this._fluid.getVelocity();
        if (oTVector2D.getY() != 0.0) {
            throw new IllegalStateException("bead motion algorithm requires horizontal fluid flow");
        }
        double d6 = this.getX();
        double d7 = this.getY();
        double d8 = this._velocity.getX();
        double d9 = this._velocity.getY();
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = d;
        int n = 1;
        if (d > 1.001 * this._dtSubdivisionThreshold) {
            d14 = d / (double)this._numberOfDtSubdivisions;
            n = this._numberOfDtSubdivisions;
        }
        OTVector2D oTVector2D2 = ZERO_VECTOR;
        OTVector2D oTVector2D3 = ZERO_VECTOR;
        OTVector2D oTVector2D4 = ZERO_VECTOR;
        for (int i = 0; i < n; ++i) {
            if (this._laser != null) {
                oTVector2D2 = this._laser.getTrapForce(d6, d7);
            }
            if (this._dnaStrand != null) {
                oTVector2D3 = this._dnaStrand.getForce(d6, d7);
            }
            if (this._brownianMotionEnabled) {
                oTVector2D4 = this.computeBrownianDisplacement(d14);
            }
            d10 = d6 + d8 * d14 + oTVector2D4.getX();
            d11 = d7 + d9 * d14 + oTVector2D4.getY();
            if (d11 < d2) {
                d11 = d2;
            } else if (d11 > d3) {
                d11 = d3;
            }
            d12 = d5 * oTVector2D2.getX() + d5 * oTVector2D3.getX() + oTVector2D.getX();
            d13 = d5 * oTVector2D2.getY() + d5 * oTVector2D3.getY() + oTVector2D.getY();
            d6 = d10;
            d7 = d11;
            d8 = d12;
            d9 = d13;
        }
        this._velocity.setXY(d12, d13);
        this.setPosition(d10, d11);
    }

    private OTVector2D computeBrownianDisplacement(double d) {
        OTVector2D oTVector2D = null;
        if (this._fluid.isEnabled()) {
            double d2 = this._fluid.getDimensionlessNormalizedViscosity();
            double d3 = this._fluid.getTemperature();
            double d4 = this._brownianMotionScale * (2200.0 / Math.sqrt(d2)) * Math.sqrt(d3 / 300.0) * Math.sqrt(d);
            double d5 = this._stepAngleRandom.nextDouble() * (Math.PI * 2);
            oTVector2D = new OTVector2D.Polar(d4, d5);
        } else {
            oTVector2D = ZERO_VECTOR;
        }
        return oTVector2D;
    }
}

