/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.defaults;

import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.opticaltweezers.defaults.GlobalDefaults;
import edu.colorado.phet.opticaltweezers.model.OTClock;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;

public class MotorsDefaults {
    public static final DoubleRange SLOW_DT_RANGE = new DoubleRange(4.0E-18, 5.0E-16);
    public static final DoubleRange FAST_DT_RANGE = new DoubleRange(1.0E-7, 4.0E-4);
    public static final double DEFAULT_DT = FAST_DT_RANGE.getMax();
    public static final OTClock CLOCK = new OTClock(25, SLOW_DT_RANGE, FAST_DT_RANGE, DEFAULT_DT);
    public static final Dimension VIEW_SIZE = new Dimension(750, 750);
    public static final Point2D MICROSCOPE_SLIDE_POSITION = new Point2D.Double(0.0, 1200.0);
    public static final double MICROSCOPE_SLIDE_ORIENTATION = Math.toRadians(0.0);
    public static final double FLUID_DIRECTION = GlobalDefaults.FLUID_DIRECTION;
    public static final DoubleRange FLUID_SPEED_RANGE = GlobalDefaults.FLUID_SPEED_RANGE;
    public static final DoubleRange FLUID_VISCOSITY_RANGE = GlobalDefaults.FLUID_VISCOSITY_RANGE;
    public static final DoubleRange FLUID_TEMPERATURE_RANGE = GlobalDefaults.FLUID_TEMPERATURE_RANGE;
    public static final DoubleRange FLUID_APT_CONCENTRATION_RANGE = new DoubleRange(0.0, 10.0, 5.0);
    public static final Point2D LASER_POSITION = new Point2D.Double(2400.0, MICROSCOPE_SLIDE_POSITION.getY());
    public static final double LASER_ORIENTATION = GlobalDefaults.LASER_ORIENTATION;
    public static final DoubleRange LASER_POWER_RANGE = GlobalDefaults.LASER_POWER_RANGE;
    public static final DoubleRange LASER_TRAP_FORCE_RATIO = GlobalDefaults.LASER_TRAP_FORCE_RATIO;
    public static final DoubleRange LASER_ELECTRIC_FIELD_SCALE_RANGE = GlobalDefaults.LASER_ELECTRIC_FIELD_SCALE_RANGE;
    public static final Point2D BEAD_POSITION = new Point2D.Double(LASER_POSITION.getX(), LASER_POSITION.getY());
    public static final double BEAD_ORIENTATION = GlobalDefaults.BEAD_ORIENTATION;
    public static final IntegerRange BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE = new IntegerRange(1, 2000, 1000);
    public static final DoubleRange BEAD_DT_SUBDIVISION_THRESHOLD_RANGE = new DoubleRange(FAST_DT_RANGE.getMin(), FAST_DT_RANGE.getMax(), 1.0E-6);
    public static final DoubleRange BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE = new DoubleRange(FAST_DT_RANGE.getMin(), FAST_DT_RANGE.getMax(), 1.0E-6);
    public static final DoubleRange BEAD_VACUUM_FAST_DT_RANGE = new DoubleRange(FAST_DT_RANGE.getMin(), FAST_DT_RANGE.getMax(), 1.0E-5);
    public static final DoubleRange BEAD_BROWNIAN_MOTION_SCALE_RANGE = GlobalDefaults.BEAD_BROWNIAN_MOTION_SCALE_RANGE;
    public static final DoubleRange BEAD_VERLET_ACCELERATION_SCALE_RANGE = GlobalDefaults.BEAD_VERLET_ACCELERATION_SCALE_RANGE;
    public static final IntegerRange BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE = GlobalDefaults.BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE;
    public static final DoubleRange BEAD_VACUUM_FAST_THRESHOLD_RANGE = GlobalDefaults.BEAD_VACUUM_FAST_THRESHOLD_RANGE;
    public static final DoubleRange BEAD_VACUUM_FAST_POWER_RANGE = GlobalDefaults.BEAD_VACUUM_FAST_POWER_RANGE;
    public static final double DNA_REFERENCE_CLOCK_STEP = FAST_DT_RANGE.getMax();
    public static final Point2D DNA_POSITION = new Point2D.Double(BEAD_POSITION.getX() - 1547.33625, BEAD_POSITION.getY());
    public static final DoubleRange DNA_SPRING_CONSTANT_RANGE = GlobalDefaults.DNA_SPRING_CONSTANT_RANGE;
    public static final DoubleRange DNA_DRAG_COEFFICIENT_RANGE = GlobalDefaults.DNA_DRAG_COEFFICIENT_RANGE;
    public static final DoubleRange DNA_EVOLUTION_DT_RANGE = GlobalDefaults.DNA_EVOLUTION_DT_RANGE;
    public static final DoubleRange DNA_KICK_CONSTANT_RANGE = GlobalDefaults.DNA_KICK_CONSTANT_RANGE;
    public static final IntegerRange DNA_NUMBER_OF_EVOLUTIONS_PER_CLOCK_STEP_RANGE = GlobalDefaults.DNA_NUMBER_OF_EVOLUTIONS_PER_CLOCK_STEP_RANGE;
    public static final DoubleRange DNA_FLUID_DRAG_COEFFICIENT_RANGE = GlobalDefaults.DNA_FLUID_DRAG_COEFFICIENT_RANGE;
    public static final Color DNA_FREE_STRAND_COLOR = Color.GRAY;
    public static final Point2D INVISIBLE_BEAD_POSITION = new Point2D.Double(DNA_POSITION.getX() - 515.77875, DNA_POSITION.getY());
    public static final double INVISIBLE_BEAD_ORIENTATION = BEAD_ORIENTATION;
    public static final IntegerRange INVISIBLE_BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE = BEAD_NUMBER_OF_DT_SUBDIVISIONS_RANGE;
    public static final DoubleRange INVISIBLE_BEAD_DT_SUBDIVISION_THRESHOLD_RANGE = BEAD_DT_SUBDIVISION_THRESHOLD_RANGE;
    public static final DoubleRange INVISIBLE_BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE = BEAD_VERLET_DT_SUBDIVISION_THRESHOLD_RANGE;
    public static final DoubleRange INVISIBLE_BEAD_VACUUM_FAST_DT_RANGE = BEAD_VACUUM_FAST_DT_RANGE;
    public static final DoubleRange INVISIBLE_BEAD_BROWNIAN_MOTION_SCALE_RANGE = BEAD_BROWNIAN_MOTION_SCALE_RANGE;
    public static final DoubleRange INVISIBLE_BEAD_VERLET_ACCELERATION_SCALE_RANGE = BEAD_VERLET_ACCELERATION_SCALE_RANGE;
    public static final IntegerRange INVISIBLE_BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE = BEAD_VERLET_NUMBER_OF_DT_SUBDIVISIONS_RANGE;
    public static final DoubleRange INVISIBLE_BEAD_VACUUM_FAST_THRESHOLD_RANGE = BEAD_VACUUM_FAST_THRESHOLD_RANGE;
    public static final DoubleRange INVISIBLE_BEAD_VACUUM_FAST_POWER_RANGE = BEAD_VACUUM_FAST_POWER_RANGE;
    public static final Point2D ENZYME_POSITION = DNA_POSITION;
    public static final double RULER_Y_POSITION = MICROSCOPE_SLIDE_POSITION.getY() + 1000.0 - 300.0;
    public static final Point POSITION_HISTOGRAM_DIALOG_OFFSET = GlobalDefaults.POSITION_HISTOGRAM_DIALOG_OFFSET;
    public static final Point FLUID_CONTROLS_DIALOG_OFFSET = new Point(10, 400);
}

