/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.opticaltweezers.control.developer;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.controls.ColorControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.opticaltweezers.OTConstants;
import edu.colorado.phet.opticaltweezers.view.DNAForceNode;
import edu.colorado.phet.opticaltweezers.view.ElectricFieldNode;
import edu.colorado.phet.opticaltweezers.view.FluidDragForceNode;
import edu.colorado.phet.opticaltweezers.view.TrapForceNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VectorsDeveloperPanel
extends JPanel {
    private TrapForceNode _trapForceNode;
    private FluidDragForceNode _fluidDragForceNode;
    private DNAForceNode _dnaForceNode;
    private ElectricFieldNode _electricFieldNode;
    private ColorControl _trapForceColorChip;
    private ColorControl _fluidDragForceColorChip;
    private ColorControl _dnaForceColorChip;
    private ColorControl _electricFieldColorChip;
    private JCheckBox _showComponentsCheckBox;

    public VectorsDeveloperPanel(Font font, Font font2, TrapForceNode trapForceNode, FluidDragForceNode fluidDragForceNode, DNAForceNode dNAForceNode, ElectricFieldNode electricFieldNode) {
        Object object;
        this._trapForceNode = trapForceNode;
        this._fluidDragForceNode = fluidDragForceNode;
        this._dnaForceNode = dNAForceNode;
        this._electricFieldNode = electricFieldNode;
        TitledBorder titledBorder = new TitledBorder("Vectors");
        titledBorder.setTitleFont(font);
        this.setBorder(titledBorder);
        PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
        Paint paint = this._trapForceNode.getArrowFillPaint();
        Color color = paint instanceof Color ? (Color)paint : Color.BLACK;
        this._trapForceColorChip = new ColorControl(phetFrame, "Trap force color:", color);
        this._trapForceColorChip.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VectorsDeveloperPanel.this._trapForceNode.setArrowFillPaint(VectorsDeveloperPanel.this._trapForceColorChip.getColor());
            }
        });
        Paint paint2 = this._fluidDragForceNode.getArrowFillPaint();
        Color color2 = paint2 instanceof Color ? (Color)paint2 : Color.BLACK;
        this._fluidDragForceColorChip = new ColorControl(phetFrame, "Fluid drag force color:", color2);
        this._fluidDragForceColorChip.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VectorsDeveloperPanel.this._fluidDragForceNode.setArrowFillPaint(VectorsDeveloperPanel.this._fluidDragForceColorChip.getColor());
            }
        });
        if (this._dnaForceNode != null) {
            object = this._dnaForceNode.getArrowFillPaint();
            Color color3 = object instanceof Color ? (Color)object : Color.BLACK;
            this._dnaForceColorChip = new ColorControl(phetFrame, "DNA force color:", color3);
            this._dnaForceColorChip.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    VectorsDeveloperPanel.this._dnaForceNode.setArrowFillPaint(VectorsDeveloperPanel.this._dnaForceColorChip.getColor());
                }
            });
        }
        if (this._electricFieldNode != null) {
            this._electricFieldColorChip = new ColorControl(phetFrame, "E-field color:", this._electricFieldNode.getVectorColor());
            this._electricFieldColorChip.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    VectorsDeveloperPanel.this._electricFieldNode.setVectorColor(VectorsDeveloperPanel.this._electricFieldColorChip.getColor());
                }
            });
        }
        this._showComponentsCheckBox = new JCheckBox("Show XY components");
        this._showComponentsCheckBox.setFont(font2);
        this._showComponentsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VectorsDeveloperPanel.this.handleShowComponentsCheckBox();
            }
        });
        object = new EasyGridBagLayout(this);
        ((EasyGridBagLayout)object).setInsets(OTConstants.SUB_PANEL_INSETS);
        this.setLayout((LayoutManager)object);
        int n = 0;
        int n2 = 0;
        ((EasyGridBagLayout)object).addComponent(this._trapForceColorChip, n++, n2);
        ((EasyGridBagLayout)object).addComponent(this._fluidDragForceColorChip, n++, n2);
        if (this._dnaForceColorChip != null) {
            ((EasyGridBagLayout)object).addComponent(this._dnaForceColorChip, n++, n2);
        }
        if (this._electricFieldColorChip != null) {
            ((EasyGridBagLayout)object).addComponent(this._electricFieldColorChip, n++, n2);
        }
        ((EasyGridBagLayout)object).addComponent(this._showComponentsCheckBox, n++, n2);
    }

    public void setComponentsVisible(boolean bl) {
        this._showComponentsCheckBox.setSelected(bl);
        this.handleShowComponentsCheckBox();
    }

    private void handleShowComponentsCheckBox() {
        boolean bl = this._showComponentsCheckBox.isSelected();
        this._trapForceNode.setComponentVectorsVisible(bl);
        this._fluidDragForceNode.setComponentVectorsVisible(bl);
        if (this._dnaForceNode != null) {
            this._dnaForceNode.setComponentVectorsVisible(bl);
        }
    }
}

